/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;


/**
 * Extends {@link ImageDisplay} to display the first
 * (according to the order attribute) image associated with an {@link Article}
 * The typical usage for this component is
 * <blockquote><pre><code>ArticleImageDisplay d = new ArticleImageDisplay(myItemSelectionModel, false);</code></pre></blockquote>
 * <p>
 *
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 * @author Michael Pih (pihman@arsdigita.com)
 * @author Stanislav Freidin (stas@arsdigita.com)
 */
public class ArticleImageDisplay extends ImageDisplay {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ArticleImageDisplay.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private final ItemSelectionModel m_article;


    /**
     * Construct a new <code>ArticleImageDisplay</code>
     *
     * @param article the {@link ItemSelectionModel} which
     *   supplies the {@link Article}
     *
     * @param assets the {@link ItemSelectionModel} which
     *   supplies the {@link ImageAsset} for the article; it is
     *   the parent's responsibility to register any state parameters
     *   for this model
     */
    public ArticleImageDisplay(ItemSelectionModel article,
                               ItemSelectionModel assets) {
        super(assets);

        m_article = article;
    }

    /**
     * @return The item selection model which supplies the
     *   current article
     */
    public final ItemSelectionModel getArticleSelectionModel() {
        return m_article;
    }

    /**
     * @param state The page state
     * @return the currently selected article
     * @post ( return != null )
     */
    protected Article getArticle(PageState state) {
        Article article = (Article) m_article.getSelectedObject(state);
        Assert.assertNotNull(article, "Article");
        return article;
    }

    /**
     * Adds the image caption as an attribute of the DOM element.
     */
    protected void generateImagePropertiesXML(ImageAsset image,
                                              PageState state,
                                              Element element) {

        super.generateImagePropertiesXML(image, state, element);

        Article article =  getArticle(state);
        String caption = article.getCaption(image);
        if ( caption != null ) {
            element.addAttribute("caption", caption);
        }
    }

}
