/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.util.UncheckedWrapperException;

/**
 * Publish to file exception.
 *
 * @author Jeff Teeters (teeters@arsdigita.com)
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class PublishToFileException extends UncheckedWrapperException {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/publishToFile/PublishToFileException.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public PublishToFileException(String message) {
        super("woohoo: " + message);
    }

    public PublishToFileException(Throwable cause) {
        super(cause);
    }

    public PublishToFileException (String msg, Throwable cause) {
        super("yo: " + msg, cause);
    }
}
