/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import org.apache.log4j.Logger;

import java.util.TimerTask;

import com.arsdigita.util.UncheckedWrapperException;


/**
 * The SchedulerTask class provides the method that is scheduled
 * by the timer created by Scheduler.  It simply calls the
 * run method of Scheduler.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 **/
class SchedulerTask extends TimerTask {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/SchedulerTask.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger(SchedulerTask.class);
    public void run() {
        try {
            Scheduler.run();
        } catch (Throwable t) {
            s_log.error("Unknown error occured. SchedulerTask disabled.", t);
            throw new UncheckedWrapperException(t);
        }
    }

}
