/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.persistence.OID;

import java.math.BigDecimal;
import java.util.Date;

/**
 * This event class stores the information necessary for the firing of events
 * in the LifecycleListener class.
 *
 * @author Jack Chung (flattop@arsdigita.com)
 * @version $Revision: #8 $ $DateTime: 2004/04/07 16:07:11 $
 */

public class LifecycleEvent {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/LifecycleEvent.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_eventType;
    private Date m_startDateTime, m_endDateTime;
    private OID m_oid;

    public final static int PHASE = 0;
    public final static int LIFECYCLE = 1;

    /**
     * Construct a lifecycle event
     *
     * @param eventType specify either PHASE or LIFECYCLE
     * @param start the start date time of this event
     * @param end the end date time of this event
     * @param objectType the object-type of the object receiving of the action
     * @param id the ID of the object receiving of the action
     */
    protected LifecycleEvent(int eventType, Date start, Date end,
                             String objectType, BigDecimal id) {
        this(eventType, start, end, new OID(objectType, id)) ;
    }

    /**
     * Construct a lifecycle event
     *
     * @param eventType specify either PHASE or LIFECYCLE
     * @param start the start date time of this event
     * @param end the end date time of this event
     * @param oid the OID of the object of receiving of the action
     */
    protected LifecycleEvent(int eventType, Date start,
                             Date end, OID oid) {
        m_eventType = eventType;
        m_startDateTime = start;
        m_endDateTime = end;
        m_oid = oid;
    }

    public int getEventType() {
        return m_eventType;
    }

    public Date getStartDate() {
        return m_startDateTime;
    }
    public Date getEndDate() {
        return m_endDateTime;
    }

    public OID getOID() {
        return m_oid;
    }

    public String toString() {
        String type;
        String endDate;

        if (m_eventType == PHASE) {
            type = "Phase";
        } else {
            type = "Lifecycle";
        }

        if ( m_endDateTime == null ) {
            endDate = "never";
        } else {
            endDate = m_endDateTime.toString();
        }

        return "LifecycleEvent (" + type + ")- startDateTime:" +
            m_startDateTime.toString() + " endDateTime:" + endDate;
    }

}
