/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentType;

import java.math.BigDecimal;

public interface ContentTypeHelper {
    public void setName(String name) ;
    /**  @deprecated */
    public void setLabel(String label) ;      
    /**  @deprecated */
    public String getLabel() ;      
    /**
     *  The labelBundle and labelKey work together to specify where
     *  to locate the given label.  These are the bundle and key use
     *  to create a GlobalizedMessage
     */
    public void setLabelBundle(String labelBundle);        
    public String getLabelBundle();

    /**
     *  The labelBundle and labelKey work together to specify where
     *  to locate the given label.  These are the bundle and key use
     *  to create a GlobalizedMessage
     */
    public void setLabelKey(String labelKey);        
    public String getLabelKey();
    public boolean isInternal();
    public void setInternal(boolean internal);
    /**  @deprecated */
    public void setDescription(String description) ;      
    /**  @deprecated */
    public String getDescription() ;      
    /**
     *  The descriptionBundle and descriptionKey work together to specify where
     *  to locate the given description.  These are the bundle and key use
     *  to create a GlobalizedMessage
     */
    public void setDescriptionBundle(String descriptionBundle);
    public String getDescriptionBundle();

    /**
     *  The descriptionBundle and descriptionKey work together to specify where
     *  to locate the given description.  These are the bundle and key use
     *  to create a GlobalizedMessage
     */
    public void setDescriptionKey(String descriptionKey);        
    public String getDescriptionKey();
    public void setObjectType(String objType);       
    public String getObjectType() ;              
    public void setClassName(String classname) ;      
    public String getClassName() ;      
    public void setParentType(String classname) ;      
    public void setCreateComponent(String createComponent);      
    public AuthoringKit getAuthoringKit() ;      
    public ContentType getContentType();           
    public ContentType createType() ;      
    public AuthoringKit createAuthoringKit();       
    /** @deprecated */
    public void addAuthoringStep(String label, 
                                 String description,
                                 String component,
                                 BigDecimal ordering) ;

    public void addAuthoringStep(String labelKey, 
                                 String labelBundle,
                                 String descriptionKey,
                                 String descriptionBundle,
                                 String component,
                                 BigDecimal ordering) ;

    public void saveType();      
}
