/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;

import java.math.BigDecimal;


/**
 * <p>This class represents a mapping of a
 * {@link com.arsdigita.cms.dispatcher.Resource} to a URL local to a
 * {@link com.arsdigita.cms.ContentSection content section}.</p>
 *
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #6 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public class ResourceMapping extends DomainObject {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ResourceMapping.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String TYPE = "com.arsdigita.cms.ResourceMapping";

    private static final String SECTION_ID = "sectionId";
    private static final String URL = "url";
    private static final String RESOURCE_ID = "resourceId";


    public ResourceMapping() {
        super(TYPE);
    }

    public ResourceMapping(String type) {
        super(type);
    }

    public ResourceMapping(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ResourceMapping(DataObject obj) {
        super(obj);
    }

    public BigDecimal getSectionID() {
        return (BigDecimal) get(SECTION_ID);
    }

    public String getUrl() {
        return (String) get(URL);
    }

    public BigDecimal getResourceID() {
        return (BigDecimal) get(RESOURCE_ID);
    }

    public void setSectionID(BigDecimal id) {
        set(SECTION_ID, id);
    }

    public void setUrl(String s) {
        set(URL, s);
    }

    public void setResourceID(BigDecimal id) {
        set(RESOURCE_ID, id);
    }

}
