/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;


import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;


/***
 *
 * XMLPage
 *
 * Designed to allow you to output straight XML directly from the ContentItem
 * that implements XMLGenerator, with none of the surrounding headers, footers, etc
 *
 * @author slater@arsdigita.com
 *
 ***/

public class ItemXML extends ResourceHandlerImpl {

    public ItemXML() {
        super();
    }

    public void dispatch(HttpServletRequest request,
                         HttpServletResponse response,
                         RequestContext actx)
        throws IOException, ServletException {
        
        ContentItem item = getContentItem(request);
        
        Element content = new Element("cms:item", CMS.CMS_XML_NS);
        
        DomainObjectXMLRenderer renderer = 
            new DomainObjectXMLRenderer(content);
        
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        
        renderer.walk(item, SimpleXMLGenerator.ADAPTER_CONTEXT);

        Document doc;
        try {
            doc = new Document(content);
        } catch (javax.xml.parsers.ParserConfigurationException e) {
            throw new javax.servlet.ServletException(e);
        }
        
        OutputStream out = response.getOutputStream();
        try {
            out.write(doc.toString(true).getBytes());
        } catch (IOException e) {
            throw new ServletException(e);
        } finally {
            out.close();
        }
    }
}
