/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ItemTemplateMapping;

import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.util.IO;
import com.arsdigita.web.BaseServlet;
import com.arsdigita.templating.Templating;
import com.arsdigita.web.Web;
import com.arsdigita.util.servlet.HttpParameterMap;
import com.arsdigita.util.servlet.HttpResourceLocator;
import java.net.URL;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.InputStream;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import org.apache.log4j.Logger;


/**
 * A servlet that takes an Template OID and a delegated URL and
 * combines them into a single XSL file.
 */
public class ContentItemXSLServlet extends BaseServlet {
    
    private static final Logger s_log = 
        Logger.getLogger(ContentItemXSLServlet.class);

    //cache for the template resolver
    public static Map s_templateResolverCache =
        Collections.synchronizedMap(new HashMap());

    protected void doService(HttpServletRequest sreq,
                             HttpServletResponse sresp)
        throws ServletException, IOException {

        String oid = sreq.getParameter("oid");
        String delegated = sreq.getParameter("delegated");
        String context = sreq.getParameter("context");

        if (s_log.isDebugEnabled()) {
            s_log.debug("Template OID is " + oid);
            s_log.debug("Delegated URL is " + delegated);
        }

        if (oid == null || delegated == null) {
            sresp.sendError(404, "Page Not Found");
            return;
        }

        ArrayList paths = new ArrayList();

        HttpParameterMap params = new HttpParameterMap();
        params.setParameter("oid", oid);
        HttpResourceLocator loc = new HttpResourceLocator(
            Web.getConfig().getHost(),
            Web.getConfig().getDispatcherContextPath(),
            "/__ccm__/servlet/template",
            "/index.xsl",
            params);

        // first, add the main cms xsl
        try {
            paths.add(new URL(delegated));            
            paths.add(loc.toURL());
        } catch (MalformedURLException me) {
            s_log.warn("Malformed URL of " + delegated, me);
            sresp.sendError(404, "Page Not Found");
            return;
        }

        InputStream is = Templating.multiplexXSLFiles(paths.iterator());
        
        sresp.setContentType("text/xml; charset=UTF-8");
        IO.copy(is, sresp.getOutputStream());
    }
}
