/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateManager;

import javax.servlet.http.HttpServletRequest;

/**
 * @author bche
 */
public abstract class AbstractTemplateResolver implements TemplateResolver {
    protected static final String TEMPLATE_CONTEXT_PREFIX = "tem_";

    /* (non-Javadoc)
     * @see com.arsdigita.cms.dispatcher.TemplateResolver#getTemplate(com.arsdigita.cms.ContentSection,
     * com.arsdigita.cms.ContentItem, javax.servlet.http.HttpServletRequest)
     */
    public abstract String getTemplate(ContentSection section,ContentItem item, HttpServletRequest request);

    /* (non-Javadoc)
     * @see com.arsdigita.cms.dispatcher.TemplateResolver#getTemplatePath(com.arsdigita.cms.Template)
     */
    public abstract String getTemplatePath(Template template);

    /* (non-Javadoc)
     * @see com.arsdigita.cms.dispatcher.TemplateResolver#setTemplateContext(java.lang.String,
     *  javax.servlet.http.HttpServletRequest)
     */
    public void setTemplateContext(String sTemplateContext, HttpServletRequest request) {
        if (sTemplateContext != null) {
            request.setAttribute("templateContext", sTemplateContext);
        }
    }

    /* (non-Javadoc)
     * @see com.arsdigita.cms.dispatcher.TemplateResolver#getTemplateContext(javax.servlet.http.HttpServletRequest)
     */
    public String getTemplateContext(HttpServletRequest request) {
        String context = (String) request.getAttribute("templateContext");
        if (context == null) {
            context = TemplateManager.PUBLIC_CONTEXT;
        }
        return context;
    }
}
