/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.StringTokenizer;

/**
 * @author bche
 */
public abstract class AbstractItemResolver implements ItemResolver {
    
    protected static final String TEMPLATE_CONTEXT_PREFIX = "tem_";

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#getItem(com.arsdigita.cms.ContentSection, java.lang.String, java.lang.String)
	 */
	public abstract ContentItem getItem(
		ContentSection section,
		String url,
		String context);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#getCurrentContext(com.arsdigita.bebop.PageState)
	 */
	public abstract String getCurrentContext(PageState state);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#generateItemURL(com.arsdigita.bebop.PageState, java.math.BigDecimal, java.lang.String, com.arsdigita.cms.ContentSection, java.lang.String)
	 */
	public abstract String generateItemURL(
		PageState state,
		BigDecimal itemId,
		String name,
		ContentSection section,
		String context);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#generateItemURL(com.arsdigita.bebop.PageState, java.math.BigDecimal, java.lang.String, com.arsdigita.cms.ContentSection, java.lang.String, java.lang.String)
	 */
	public abstract String generateItemURL(
		PageState state,
		BigDecimal itemId,
		String name,
		ContentSection section,
		String context,
		String templateContext);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#generateItemURL(com.arsdigita.bebop.PageState, com.arsdigita.cms.ContentItem, com.arsdigita.cms.ContentSection, java.lang.String)
	 */
	public abstract String generateItemURL(
		PageState state,
		ContentItem item,
		ContentSection section,
		String context);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#generateItemURL(com.arsdigita.bebop.PageState, com.arsdigita.cms.ContentItem, com.arsdigita.cms.ContentSection, java.lang.String, java.lang.String)
	 */
	public abstract String generateItemURL(
		PageState state,
		ContentItem item,
		ContentSection section,
		String context,
		String templateContext);

	/* (non-Javadoc)
	 * @see com.arsdigita.cms.dispatcher.ItemResolver#getMasterPage(com.arsdigita.cms.ContentItem, javax.servlet.http.HttpServletRequest)
	 */
	public abstract CMSPage getMasterPage(ContentItem item, HttpServletRequest request) throws ServletException;    
    
    /**
     * Finds the template context from the URL and returns it, if it is there.
     * Otherwise, returns null.
     * @param inUrl the URL from which to get the template context
     * @return the template context, or null if there is no template context
     */
    public String getTemplateFromURL(String inUrl) {
        String tempUrl;
               String url;
               if (inUrl.startsWith("/")) {
                   tempUrl = inUrl.substring(1);
               } else {
                   tempUrl = inUrl;
               }

               String templateContext = null;
               StringTokenizer tokenizer = new StringTokenizer
                   (tempUrl, "/");

               if (tokenizer.hasMoreTokens()) {
                   templateContext = tokenizer.nextToken();
               }

               if (templateContext != null && templateContext.startsWith(TEMPLATE_CONTEXT_PREFIX)) {
                   return templateContext.substring(TEMPLATE_CONTEXT_PREFIX.length());
               } else {
                   return null;
               }
    }       

    /**
     * Removes the template context from the <code>inUrl</code>.
     *
     * @param inUrl URL, possibly including the template context.
     * @return <code>inUrl</code> with the template context removed
     */
    public String stripTemplateFromURL(String inUrl) {
        String sTemplateContext = getTemplateFromURL(inUrl);
                 
        if (sTemplateContext != null) {
            //there is a template context, so strip it
	    int iTemplateLength = TEMPLATE_CONTEXT_PREFIX.length() + 
		sTemplateContext.length() + 1;
            String sStripped = inUrl.substring(iTemplateLength, inUrl.length());
            return sStripped;
        } else {            
            return inUrl;
        }
    }

}
