/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
/**
 * SelectionModel to track the current Link object for view/edit purposes.
 */
public class LinkSelectionModel extends ACSObjectSelectionModel {
    
    public LinkSelectionModel(BigDecimalParameter param) {
	super(Link.class.getName(),
	      Link.BASE_DATA_OBJECT_TYPE,
	      param);
    }

    /**
     * Construct a new <code>LinkSelectionModel</code>
     *
     * @param itemClass The name of the Java class which represents
     *    the content item. Must be a subclass of Link. In
     *    addition, the class must have a constructor with a single
     *    OID parameter.
     * @param objectType The name of the persistence metadata object type
     *    which represents the content item. In practice, will often be
     *    the same as the itemClass.
     * @param parameter The state parameter which should be used by this item
     */
    public LinkSelectionModel(String itemClass, String objectType,
                              BigDecimalParameter parameter) {
        super(itemClass, objectType, parameter);
    }

    /**
     * Returns the currently-selected Link
     *
     * @param state the PageState for the current request.
     * @return The current Link
     */
    public Link getSelectedLink(PageState state) {
	return (Link)getSelectedObject(state);
    }
}
