/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.domain.DomainObjectTraversalAdapter;

import org.apache.log4j.Logger;

/**
 * A item adapter handler that registers the adapter to the 
 * general content item handler.
 */
public class ContentAssetTraversalHandler extends TraversalHandler {

    public static final Logger s_log = 
        Logger.getLogger(ContentAssetTraversalHandler.class);

    private String m_property;
    
    public ContentAssetTraversalHandler(String property) {
        m_property = property;
    }

    protected void registerAdapter(String objectType,
                                   DomainObjectTraversalAdapter adapter,
                                   String context) {
        if (s_log.isDebugEnabled()) {
            s_log.debug("Registering asset adapter " + adapter.getClass() + 
                        " for " + objectType  + " in context " + context + 
                        " with property " + m_property);
        }
        ContentItemTraversalAdapter.registerAssetAdapter(m_property,
                                                         adapter,
                                                         context);
    }
}
