/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

/**
 * Manages a single system-wide instance of a
 * <code>TemplateManager</code>.  Right now this is hardcoded to
 * return a <code>DefaultTemplateManager</code>.  In the future it may
 * be configurable.
 *
 * @author Karl Goldstein (karlg@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class TemplateManagerFactory {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/TemplateManagerFactory.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static TemplateManager s_templateManager =
        new DefaultTemplateManager();

    public static TemplateManager getInstance() {

        return s_templateManager;
    }
}
