/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.mimetypes.MimeType;


/**
 * Represents a collection of template mappings along with their
 * link attributes.
 *
 * @author Stanislav Freidin (sfreidin@arsdigita.com)
 * @version $Id: //cms/dev/src/com/arsdigita/cms/TemplateCollection.java#9 $
 *
 * @see com.arsdigita.domain.DomainCollection
 * @see com.arsdigita.persistence.DataCollection
 * @see com.arsdigita.cms.ItemTemplateCollection
 */
public abstract class TemplateCollection extends DomainCollection {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/TemplateCollection.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String USE_CONTEXT  = "useContext";
    public static final String IS_DEFAULT   = "isDefault";
    public static final String TEMPLATE     = "template";

    /**
     * Constructor.
     *
     **/
    public TemplateCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Set the order of this Collection. This method needs to be called
     * before <code>next()</code> is called on this collection.
     *
     */
    public void addOrder(String order) {
        m_dataCollection.addOrder(order);
    }

    /**
     * Return the current template
     */
    public abstract Template getTemplate();

    /**
     * Return the current use context
     */
    public abstract String getUseContext();

    /**
     * Return true if the current template is the default for its context
     */
    public abstract Boolean isDefault();

    /**
     *  this is the mime type for this context but does not necessarily
     *  have to be the same mime type that is returned by calling
     *  getTemplate().getMimeType().  This can return null
     */
    public MimeType getMimeType() {
        Template template = getTemplate();
        if (template != null) {
            return template.getMimeType();
        }
        return null;
    }
    
    /**
     * Filter this collection for equality by the specified attribute
     */
    public Filter addEqualsFilter(String attr, Object value)
        throws PersistenceException {
        return m_dataCollection.addEqualsFilter(attr, value);
    }

    /**
     * Return the internal DataCollection
     */
    public DataCollection getDataCollection() {
        return m_dataCollection;
    }

}
