/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.persistence.DataQuery;


/**
 * <p>Verifies that a specified {@link
 * com.arsdigita.persistence.DataQuery data query} has no results.
 * This is useful for making sure emails are unique in the
 * database.</p>
 *
 * <p>Users of this class must override the method {@link
 * #getDataQuery} which specifies the data query to check.</p>
 *
 * @author Uday Mathur (umathur@arsdigita.com)
 * @author Michael Pih (pihman@arsdigita.com)
 * @version $Revision: #7 $ $DateTime: 2004/04/07 16:07:11 $
 */
public abstract class DataQueryExistsListener 
        implements FormValidationListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/DataQueryExistsListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected String m_errorMsg;


    /**
     * @param msg An error message
     */
    public DataQueryExistsListener(String msg) {
        m_errorMsg = msg;
    }

    public abstract DataQuery getDataQuery(FormSectionEvent event);

    public void validate(FormSectionEvent event) throws FormProcessException {
        DataQuery dq = getDataQuery(event);
        if ( dq.next() ) {
            dq.close();
            throw new FormProcessException(m_errorMsg);
        }
        dq.close();
    }
}
