/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.cms;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.persistence.DataObject;

/**
 * Implements the {@link DomainObjectInstantiator} for {@link
 * com.arsdigita.cms.ContentItem content items} using reflection. This
 * class should always instantiate the right subclass of {@link
 * com.arsdigita.cms.ContentItem} automatically.
 *
 * @deprecated Use {@link com.arsdigita.kernel.ACSObjectInstantiator}
 * instead
 * @author <a href="mailto:sfreidin@arsdigita.com">Stanislav Freidin</a>
 * @version $Id: //cms/dev/src/com/arsdigita/cms/ContentItemInstantiator.java#9 $
 */
public class ContentItemInstantiator extends DomainObjectInstantiator {

    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentItemInstantiator.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Construct a {@link ContentItem} given a data object.  Called from
     * DomainObjectFactory.newInstance() as the last step of
     * instantiation.
     *
     * @param dataObject The data object from which to construct a domain
     * object.
     *
     * @return A domain object for this data object.
     */
    public DomainObject doNewInstance(DataObject dataObject) {
        return ACSObjectFactory.castContentItem(dataObject);
    }
}
