--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/comment-content_sections.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

comment on table content_sections is '
  A content section represents a CMS application instance. Each section 
  has a root folder, root category, staff group, and viewers group.
';
comment on column content_sections.root_folder_id is '
  The topmost (root) folder for draft items in this content section. All
  items in this folder will have their version equal to ''draft''. Live
  items are in the live version of this folder.
';
comment on column content_sections.templates_folder_id is '
  The topmost (root) folder for all templates in the content section
';
comment on column content_sections.staff_group_id is '
  Each content section will have a staff group, which will contain
  all privileged groups under this section.
';
comment on column content_sections.viewers_group_id is '
  Each content section will have a viewers group, which will contain
  all non-privileged groups under this section.
';
comment on column content_sections.page_resolver_class is '
  The page resolver class is the name Java class that is used to map
  URL stubs to CMS resources within a specific section.
';
comment on column content_sections.item_resolver_class is '
  The item resolver class is the name Java class that is used to map
  URL stubs to content items within a specific section. The item
  resolver will also fetch the template associated with a content item.
';
comment on column content_sections.template_resolver_class is '
  The template resolver class is the name Java class that is used to 
  obtain the template context associated with a request.
';
comment on column content_sections.xml_generator_class is '
  The XML generator class is the name Java class that is used to output
  content items in XML.
';
