--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/postgres/upgrade/5.2.1-6.0.0/update-lifecycles.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


-- add the new ITEM_ID column
alter table acs_object_lifecycle_map
  add item_id INTEGER
      constraint acs_obj_cycle_map_item_id_fk
        references acs_objects(object_id);

-- set the ITEM_ID column to the old OBJECT_ID
update acs_object_lifecycle_map
   set item_id = object_id;

-- make the updated ITEM_ID column not null
alter table acs_object_lifecycle_map
  alter column item_id set not null;

-- Update ACS_OBJECT_LIFECYCLE_MAP.OBJECT_ID with new, unused
-- ids.  This is not technically necessary, but we do it for clarity.
update acs_object_lifecycle_map
   set object_id = nextval('acs_object_id_seq');

-- remove the unused VERSION_TAG column
alter table acs_object_lifecycle_map
  drop column version_tag;
