--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.1.0-5.2.0/misc.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


-- Promote all plain articles to article + lead
update acs_objects 
   set default_domain_class = 'com.arsdigita.cms.contenttypes.Article',
       object_type          = 'com.arsdigita.cms.contenttypes.Article'
 where default_domain_class = 'com.arsdigita.cms.Article';

insert into ct_articles (item_id) 
     select article_id 
       from cms_articles 
      where article_id not in (select article_id from ct_articles);

update cms_items 
   set type_id = (select type_id 
                    from content_types 
                   where object_type = 'com.arsdigita.cms.contenttypes.Article')
 where type_id = (select type_id 
                    from content_types 
                   where object_type = 'com.arsdigita.cms.Article');

-- Now remove the content types
delete from content_types where object_type in (
  'com.arsdigita.cms.Article',
  'com.arsdigita.cms.contenttypes.ArticleSection'
);

alter table cms_pages add ( launch_date DATE);

insert into cat_root_cat_object_map (object_id, category_id)
  (select section_id, root_category_id from content_sections);

alter table content_sections drop column root_category_id;

alter table cat_category_purpose_map modify (category_id not null);
alter table cat_category_purpose_map modify (purpose_id not null);
alter table cms_mime_status modify (hash_code not null);
alter table cms_mime_status modify (inso_filter_works not null);
alter table phases modify (cycle_id null);

alter table cms_version_map modify (timestamp default null);

drop table ct_mp_articles_map;
