--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/comment-cms_category_template_map.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

comment on table cms_category_template_map is '
  Maps (category + type) to templates. Each content type
  within each category can have a different subset of templates.
  This table defines a set of templates which could possibly
  be assigned to content items.
';

comment on column cms_category_template_map.use_context is '
  A string that describes the context in which the template is
  to be used. There can be multiple templates registered to
  a content type in a certain context; for example, a 
  public template may be used to display items on the public
  pages, and a summary template may be used to display items
  as search results.
';

comment on column cms_category_template_map.is_default is '
  A boolean value that determines whether the given template
  is the default template for its use context.
';
