--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.1.0-5.2.0/change-lifecycles-phases-column-type.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


alter table lifecycles add (startDateTemp date);
alter table lifecycles add (endDateTemp date);
alter table phases add (startDateTemp date);
alter table phases add (endDateTemp date);

create global temporary table updateTimeZonesTable (
currentTime timestamp with time zone);

-- we create the table and do the insert to get the time stamp.  There
-- may be a much better way to do this but I am not sure what it is
-- we have to adjust for the time zone because when the java created the
-- number it took the time zone in to account but standard multiplication
-- does not.  This would then leave us several hours off the mark.
insert into updateTimeZonesTable values (localtimestamp);

declare
  offsetSign integer;
  hourOffset integer;
  minuteOffset integer;
begin
  select TO_CHAR(currentTime, 'TZH') into hourOffset from updateTimeZonesTable;
  select TO_CHAR(currentTime, 'TZM') into minuteOffset from updateTimeZonesTable;
  if (hourOffset < 0) then
     offsetSign := -1;
  else 
     offsetSign := 1;
  end if;

  update phases set startDateTemp = to_date('01-01-1970', 'MM-DD-YYYY') + (start_date_time/3600000)/24 + hourOffset/24 + minuteOffset/24/60*offsetSign, endDateTemp = to_date('01-01-1970', 'MM-DD-YYYY') + (end_date_time/3600000)/24 + hourOffset/24 + (minuteOffset/24/60)*offsetSign where start_date_time is not null;

  update lifecycles set startDateTemp = to_date('01-01-1970', 'MM-DD-YYYY') + (start_date_time/3600000)/24 + hourOffset/24 + minuteOffset/24/60*offsetSign, endDateTemp = to_date('01-01-1970', 'MM-DD-YYYY') + (end_date_time/3600000)/24 + hourOffset/24 + (minuteOffset/24/60)*offsetSign where start_date_time is not null;

end;
/
show errors;

drop table updateTimeZonesTable;


alter table lifecycles drop column end_date_time;
alter table lifecycles drop column start_date_time;
alter table phases drop column end_date_time;
alter table phases drop column start_date_time;

alter table lifecycles add (start_date_time date);
alter table lifecycles add (end_date_time date);
alter table phases add (start_date_time date);
alter table phases add (end_date_time date);

update phases set end_date_time = endDateTemp, start_date_time = startDateTemp;
update lifecycles set end_date_time = endDateTemp, start_date_time = startDateTemp;

alter table phases modify (start_date_time date not null);

alter table lifecycles drop column endDateTemp;
alter table lifecycles drop column startDateTemp;
alter table phases drop column endDateTemp;
alter table phases drop column startDateTemp;

-- These columns changed from varchar2(1) to char(1)
alter table lifecycles modify (has_begun char(1));
alter table lifecycles modify (has_ended char(1));
alter table phases modify (has_begun char(1));
alter table phases modify (has_ended char(1));
