--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/table-publish_to_fs_links.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $


-- Domain object type is "PublishedLink".
create table publish_to_fs_links (
    id				integer
                                constraint publish_to_fs_links_pk primary key,
    source                      integer
				constraint publish_to_fs_links_source_fk
                                references publish_to_fs_files
				on delete cascade,
    target                      integer
				constraint publish_to_fs_links_target_fk
                                references publish_to_fs_files
				on delete cascade,
    is_child                    char(1)
				constraint publish_to_fs_files_child_ck
				check (is_child in ('0', '1')),
    constraint publish_to_fs_links_un 
               unique(source, target)
);
