--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/oracle-se/upgrade/5.1.0-5.2.0/rename-column-ct-events.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

create table ct_events_temp as select * from ct_events;

drop table ct_events;
create table ct_events (
    item_id INTEGER not null
        constraint ct_events_item_id_p_56u9u
          primary key,
        -- referential constraint for item_id deferred due to circular dependencies
    cost VARCHAR(1000),
    end_date DATE,
    end_time DATE,
    event_date VARCHAR(1000),
    event_type VARCHAR(1000),
    location VARCHAR(1000),
    main_contributor VARCHAR(1000),
    map_link VARCHAR(1000),
    start_date DATE,
    start_time DATE,
    tease_lead VARCHAR(4000)
);

alter table ct_events add 
    constraint ct_events_item_id_f_v7kjv foreign key (item_id)
      references cms_text_pages(item_id) on delete cascade;

insert into ct_events
   (item_id,
    cost,
    end_date,
    end_time,
    event_date,
    event_type,
    location,
    main_contributor,
    map_link,
    start_date,
    start_time,
    tease_lead)
 select 
    item_id,
    cost,
    end_date,
    end_time,
    event_date,
    event_type,
    location,
    mact_contributor,
    map_link,
    start_date,
    start_time,
    tease_lead
    from ct_events_temp;

drop table ct_events_temp;
