--
-- Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //cms/dev/sql/ccm-cms/default/content-section/comment-cms_items.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

comment on table cms_items is '
  Basic metadata required of every content item.
  Items come in two versions: ''live'' and ''draft'', which are stored 
  in separate folder hierarchies, live items in the hierarchy starting with
  a content section''s live_folder_id, draft items in the one with id
  draft_folder_id.
';
comment on column cms_items.parent_id is '
  The primary folder for this item.  Used to build a virtual item
  hierarchy for the purpose of assigning unique URLs to all items.
  Root level folders have a parent_id of null. There should not be any
  non-folders with null parent_id''s.
';
comment on column cms_items.version is '
  The version tag of the item can be set to ''live'' for live version and
  ''draft'' for the draft version.
';
comment on column cms_items.section_id is '
  This is a denormalization of the content section for items that exist
  within the folder hierarchy (site map) of a content section.
';
