/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.UserSearchForm;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.workflow.TaskAddRole;
import com.arsdigita.cms.ui.workflow.TaskAddUser;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.ui.workflow.WorkflowRequestLocal;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

final class TaskItemPane
extends BaseItemPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskItemPane.java#16 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final WorkflowRequestLocal m_workflow;
    private final TaskRequestLocal m_task;
    private final SimpleContainer m_detailPane;

    TaskItemPane(WorkflowRequestLocal workflow, TaskRequestLocal task, ActionLink finishLink, ActionLink editLink, ActionLink deleteLink, ActionLink backLink) {
        this.m_workflow = workflow;
        this.m_task = task;
        this.m_detailPane = new SimpleContainer();
        this.m_detailPane.add((Component)new Navigation(backLink));
        this.m_detailPane.add((Component)new SummarySection(finishLink, editLink, deleteLink));
        ActionLink userAddLink = new ActionLink((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.user.add")));
        TaskAddUser userAddPane = new TaskAddUser(this.m_task);
        UserSearchForm search = userAddPane.getSearchForm();
        Form add = userAddPane.getAddForm().getForm();
        this.m_detailPane.add((Component)new UserSection(userAddLink));
        ActionLink roleAddLink = new ActionLink((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.role.add")));
        TaskAddRole roleAddForm = new TaskAddRole(this.m_task);
        this.m_detailPane.add((Component)new RoleSection(roleAddLink));
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.add((Component)userAddPane);
        this.add((Component)roleAddForm);
        userAddLink.addActionListener((ActionListener)new ModalPanel.NavigationListener((ModalPanel)this, (Component)userAddPane));
        search.addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)search));
        add.addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)add));
        add.addProcessListener((FormProcessListener)new ModalPanel.FormNavigationListener((ModalPanel)this, (Component)this.m_detailPane));
        this.connect(roleAddLink, (FormSection)roleAddForm);
        this.resume((FormSection)roleAddForm, (Component)this.m_detailPane);
    }

    private boolean hasAdmin(PageState state) {
        SecurityManager sm = CMS.getContext().getSecurityManager();
        return sm.canAccess(state.getRequest(), "workflow_admin");
    }

    private static class RoleTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private final TaskRequestLocal m_task;

        public RoleTableModelBuilder(TaskRequestLocal task) {
            this.m_task = task;
        }

        public final TableModel makeModel(Table table, PageState state) {
            return new Model(this.m_task.getTask(state));
        }

        private class Model
        implements TableModel {
            private Group m_role;
            private final GroupCollection m_roles;

            private Model(CMSTask task) {
                this.m_roles = task.getAssignedGroupCollection();
            }

            public final int getColumnCount() {
                return 2;
            }

            public final boolean nextRow() {
                if (this.m_roles.next()) {
                    this.m_role = this.m_roles.getGroup();
                    return true;
                }
                this.m_roles.close();
                return false;
            }

            public final Object getKeyAt(int column) {
                return this.m_role.getID().toString();
            }

            public final Object getElementAt(int column) {
                switch (column) {
                    case 0: {
                        return this.m_role.getName();
                    }
                    case 1: {
                        return TaskItemPane.lz("cms.ui.workflow.task.role.delete");
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    private class RoleTable
    extends Table {
        public RoleTable() {
            super((TableModelBuilder)new RoleTableModelBuilder(TaskItemPane.this.m_task), (Object[])new String[]{TaskItemPane.lz("cms.ui.name"), TaskItemPane.lz("cms.ui.workflow.task.role.delete")});
            this.setEmptyView((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.role.none")));
            this.getColumn(1).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
            this.addTableActionListener((TableActionListener)new TableActionAdapter(this){
                private final /* synthetic */ RoleTable this$1;
                {
                    this.this$1 = this$1;
                }

                public final void cellSelected(TableActionEvent e) {
                    PageState state = e.getPageState();
                    int column = e.getColumn();
                    if (column == 1 && TaskItemPane.access$400(RoleTable.access$3300(this.this$1), state)) {
                        CMSTask task = TaskItemPane.access$300(RoleTable.access$3300(this.this$1)).getTask(state);
                        BigDecimal id = new BigDecimal((String)e.getRowKey());
                        task.removeGroup(new Group(id));
                        task.save();
                    }
                }
            });
        }

        public final void register(Page page) {
            super.register(page);
            page.addActionListener((ActionListener)new VisibilityListener(this.getColumn(1)));
        }

        static /* synthetic */ TaskItemPane access$3300(RoleTable x0) {
            return x0.TaskItemPane.this;
        }
    }

    private class RoleSection
    extends Section {
        public RoleSection(ActionLink roleAddLink) {
            this.setHeading((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.roles")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new RoleTable());
            group.addAction((Component)new AdminVisible((Component)roleAddLink), "add");
        }
    }

    private static class UserTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private final TaskRequestLocal m_task;

        public UserTableModelBuilder(TaskRequestLocal task) {
            this.m_task = task;
        }

        public final TableModel makeModel(Table table, PageState state) {
            return new Model(this.m_task.getTask(state));
        }

        private class Model
        implements TableModel {
            private User m_user;
            private final UserCollection m_users;

            private Model(CMSTask task) {
                this.m_users = task.getAssignedUserCollection();
            }

            public final int getColumnCount() {
                return 3;
            }

            public final boolean nextRow() {
                if (this.m_users.next()) {
                    this.m_user = this.m_users.getUser();
                    return true;
                }
                this.m_users.close();
                return false;
            }

            public final Object getKeyAt(int column) {
                return this.m_user.getID().toString();
            }

            public final Object getElementAt(int column) {
                switch (column) {
                    case 0: {
                        return this.m_user.getName();
                    }
                    case 1: {
                        EmailAddress email = this.m_user.getPrimaryEmail();
                        if (email == null) {
                            return "";
                        }
                        return email.toString();
                    }
                    case 2: {
                        return TaskItemPane.lz("cms.ui.workflow.task.user.delete");
                    }
                }
                throw new IllegalStateException();
            }
        }
    }

    private class UserTable
    extends Table {
        public UserTable() {
            super((TableModelBuilder)new UserTableModelBuilder(TaskItemPane.this.m_task), (Object[])new String[]{TaskItemPane.lz("cms.ui.name"), TaskItemPane.lz("cms.ui.email"), TaskItemPane.lz("cms.ui.workflow.task.user.delete")});
            this.setEmptyView((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.user.none")));
            this.getColumn(2).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(true));
            this.addTableActionListener((TableActionListener)new TableActionAdapter(this){
                private final /* synthetic */ UserTable this$1;
                {
                    this.this$1 = this$1;
                }

                public final void cellSelected(TableActionEvent e) {
                    PageState state = e.getPageState();
                    int column = e.getColumn();
                    if (column == 2 && TaskItemPane.access$400(UserTable.access$2600(this.this$1), state)) {
                        CMSTask task = TaskItemPane.access$300(UserTable.access$2600(this.this$1)).getTask(state);
                        BigDecimal id = new BigDecimal((String)e.getRowKey());
                        task.removeUser(User.retrieve((BigDecimal)id));
                        task.save();
                    }
                }
            });
        }

        public final void register(Page page) {
            super.register(page);
            page.addActionListener((ActionListener)new VisibilityListener(this.getColumn(2)));
        }

        static /* synthetic */ TaskItemPane access$2600(UserTable x0) {
            return x0.TaskItemPane.this;
        }
    }

    private class UserSection
    extends Section {
        public UserSection(ActionLink userAddLink) {
            this.setHeading((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.users")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new UserTable());
            group.addAction((Component)new AdminVisible((Component)userAddLink), "add");
        }
    }

    private class SummarySection
    extends Section {
        SummarySection(ActionLink finishLink, ActionLink editLink, ActionLink deleteLink) {
            this.setHeading((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new AssigneeVisible((Component)new LockLink()));
            group.addAction((Component)new AssigneeVisible((Component)new UnlockLink()));
            group.addAction((Component)new AssigneeVisible((Component)finishLink));
            group.addAction((Component)new AdminVisible((Component)editLink), "edit");
            group.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                CMSTask task = TaskItemPane.this.m_task.getTask(state);
                props.add(new PropertyList.Property(TaskItemPane.gz("cms.ui.name"), task.getLabel()));
                props.add(new PropertyList.Property(TaskItemPane.gz("cms.ui.description"), task.getDescription()));
                props.add(new PropertyList.Property(TaskItemPane.gz("cms.ui.workflow.task.dependencies"), this.deps(task)));
                props.add(new PropertyList.Property(TaskItemPane.gz("cms.ui.workflow.task.state"), task.getStateString()));
                props.add(new PropertyList.Property(TaskItemPane.gz("cms.ui.workflow.task.locked"), task.isLocked() ? TaskItemPane.lz("cms.ui.yes") : TaskItemPane.lz("cms.ui.no")));
                return props;
            }

            private String deps(CMSTask task) {
                TaskCollection deps = task.getRequiredTasks();
                StringBuffer buffer = new StringBuffer();
                while (deps.next()) {
                    buffer.append(deps.getTask().getLabel() + ", ");
                }
                int len = buffer.length();
                if (len >= 2) {
                    buffer.setLength(len - 2);
                }
                deps.close();
                return buffer.toString();
            }
        }

        private class UnlockLink
        extends ActionLink {
            UnlockLink() {
                super((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.unlock")));
                this.addActionListener(new Listener());
            }

            public final boolean isVisible(PageState state) {
                CMSTask task = TaskItemPane.this.m_task.getTask(state);
                return task.isEnabled() && task.isLocked();
            }

            private class Listener
            implements ActionListener {
                private Listener() {
                }

                public final void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    if (TaskItemPane.this.hasAdmin(state)) {
                        CMSTask task = TaskItemPane.this.m_task.getTask(state);
                        task.unlock(Web.getContext().getUser());
                        task.save();
                    }
                }
            }
        }

        private class LockLink
        extends ActionLink {
            LockLink() {
                super((Component)new Label(TaskItemPane.gz("cms.ui.workflow.task.lock")));
                this.addActionListener(new Listener());
            }

            public final boolean isVisible(PageState state) {
                CMSTask task = TaskItemPane.this.m_task.getTask(state);
                return task.isEnabled() && !task.isLocked();
            }

            private class Listener
            implements ActionListener {
                private Listener() {
                }

                public final void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    if (TaskItemPane.this.hasAdmin(state)) {
                        CMSTask task = TaskItemPane.this.m_task.getTask(state);
                        task.lock(Web.getContext().getUser());
                        task.save();
                    }
                }
            }
        }
    }

    private class Navigation
    extends ActionGroup {
        Navigation(ActionLink backLink) {
            this.addAction((Component)backLink, "return");
        }
    }

    private class VisibilityListener
    implements ActionListener {
        private final TableColumn m_column;

        VisibilityListener(TableColumn column) {
            this.m_column = column;
        }

        public final void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            if (state.isVisibleOnPage((Component)TaskItemPane.this) && !TaskItemPane.this.hasAdmin(state)) {
                this.m_column.setVisible(state, false);
            }
        }
    }

    private class AssigneeVisible
    extends AdminVisible {
        private final Component m_child;
        private final Assigned m_assigned;

        public AssigneeVisible(Component child) {
            super(child);
            this.m_child = child;
            this.m_assigned = new Assigned();
        }

        public final boolean isVisible(PageState state) {
            if (this.m_child.isVisible(state)) {
                return this.m_assigned.isAssigned(state) || this.hasPermission(state);
            }
            return false;
        }

        private class Assigned
        extends RequestLocal {
            private Assigned() {
            }

            protected final Object initialValue(PageState state) {
                if (this.assigned(state)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            private boolean assigned(PageState state) {
                Workflow workflow = TaskItemPane.this.m_workflow.getWorkflow(state);
                User user = Web.getContext().getUser();
                CMSTask task = TaskItemPane.this.m_task.getTask(state);
                Engine engine = Engine.getInstance();
                ArrayList tasks = engine.getEnabledTasks(user, workflow.getID());
                return tasks.contains((Object)task);
            }

            final boolean isAssigned(PageState state) {
                return (Boolean)this.get(state);
            }
        }
    }

    private class AdminVisible
    extends VisibilityComponent {
        public AdminVisible(Component child) {
            super(child, "workflow_admin");
        }
    }
}

