/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ItemTemplateMapping;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.ui.templates.TemplatesListing;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import javax.servlet.ServletRequest;

public abstract class ItemTemplatesListing
extends TemplatesListing {
    private ItemSelectionModel m_itemModel;
    private TableColumn m_assignCol;
    private TableColumn m_previewCol;
    private RequestLocal m_currentContext;
    public static final String FULL_KEY = "fullUniqueKey";
    public static final String SEP_CHAR = ";";

    public ItemTemplatesListing(ItemSelectionModel itemModel) {
        super(new MappingSelectionModel(itemModel));
        this.m_itemModel = itemModel;
        this.setDataQueryBuilder(new TemplatesListing.AbstractQueryBuilder(){

            public String getKeyColumn() {
                return ItemTemplatesListing.FULL_KEY;
            }
        });
        this.setModelBuilder((TableModelBuilder)new ItemTemplatesListingModelBuilder());
        this.addRemoveColumn();
        this.m_assignCol = this.addColumn("Assign", new AssignCellRenderer());
        this.m_previewCol = this.addColumn("Preview", "useContext", false, new PreviewCellRenderer(itemModel));
        this.addTableActionListener((TableActionListener)new TableActionAdapter(){

            public void cellSelected(TableActionEvent e) {
                PageState s = e.getPageState();
                TemplatesListing l = (TemplatesListing)((Object)e.getSource());
                int i = e.getColumn();
                TableColumn c = l.getColumnModel().get(i);
                if (c == ItemTemplatesListing.this.m_assignCol) {
                    String useContext = (String)ItemTemplatesListing.this.getMappingModel().getSelectedKey(s);
                    ContentItem item = ItemTemplatesListing.this.m_itemModel.getSelectedItem(s);
                    ItemTemplatesListing.this.assignLinkClicked(s, item, useContext);
                }
            }
        });
    }

    public final TableColumn getAssignColumn() {
        return this.m_assignCol;
    }

    public final TableColumn getPreviewColumn() {
        return this.m_previewCol;
    }

    protected TemplateCollection getTemplateCollection(PageState s) {
        ContentItem item = this.m_itemModel.getSelectedItem(s);
        return TemplateManagerFactory.getInstance().getContextsWithTypes(item);
    }

    protected void removeTemplate(PageState s, TemplateMapping m) {
        if (m == null) {
            return;
        }
        MimeType mimeType = ItemTemplatesListing.getMimeTypeFromKey((String)this.getMappingModel().getSelectedKey(s));
        TemplateManagerFactory.getInstance().removeTemplate((ContentItem)m.getParent(), m.getTemplate(), m.getUseContext());
    }

    protected abstract void assignLinkClicked(PageState var1, ContentItem var2, String var3);

    public static MimeType getMimeTypeFromKey(String key) {
        if (key == null) {
            return null;
        }
        int index = key.lastIndexOf(SEP_CHAR);
        String mimeString = null;
        if (index < 0) {
            mimeString = key;
        } else {
            if (key.length() == index + 1) {
                return null;
            }
            mimeString = key.substring(index + 1);
        }
        return MimeType.loadMimeType((String)mimeString);
    }

    public static String getObjectIDFromKey(String key) {
        if (key == null) {
            return null;
        }
        int beginIndex = key.indexOf(SEP_CHAR);
        int endIndex = key.lastIndexOf(SEP_CHAR);
        if (beginIndex < 0) {
            return key;
        }
        if (endIndex == beginIndex) {
            return null;
        }
        return key.substring(beginIndex, endIndex - beginIndex);
    }

    public static String getUseContextFromKey(String key) {
        if (key == null) {
            return null;
        }
        int index = key.indexOf(SEP_CHAR);
        if (index < 0) {
            return key;
        }
        return key.substring(0, index);
    }

    protected static String buildKey(String useContext, String id, MimeType mimeType) {
        if (id == null) {
            id = "";
        }
        String mimeString = "";
        if (mimeType != null) {
            mimeString = mimeType.getMimeType();
        }
        return useContext + SEP_CHAR + id + SEP_CHAR + mimeString;
    }

    protected static class ItemTemplatesListingTableModel
    extends DataTable.DataQueryTableModel {
        private DataQuery m_data;
        private DataTable.DataTableColumnModel m_cols;
        private String m_keyColumn;

        public ItemTemplatesListingTableModel(DataTable t, DataQuery data, String keyColumn) {
            super(t, data, keyColumn);
            this.m_data = data;
            this.m_cols = (DataTable.DataTableColumnModel)t.getColumnModel();
            this.m_keyColumn = keyColumn;
        }

        public Object getElementAt(int columnIndex) {
            String key = (String)this.m_cols.get(columnIndex).getHeaderKey();
            if (key != null) {
                return this.m_data.get(key);
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            String key = this.m_cols.getKeyAt(columnIndex);
            if (ItemTemplatesListing.FULL_KEY.equals(key) || key == null && ItemTemplatesListing.FULL_KEY.equals(this.m_keyColumn)) {
                return this.getIDString();
            }
            if (key != null) {
                return this.m_data.get(key);
            }
            return super.getKeyAt(columnIndex);
        }

        private String getIDString() {
            DataObject object;
            String useContext = (String)this.m_data.get("useContext");
            String id = null;
            DataObject templateObject = (DataObject)this.m_data.get("template");
            MimeType mimeType = null;
            if (templateObject != null) {
                Template item = (Template)DomainObjectFactory.newInstance((DataObject)templateObject);
                mimeType = item.getMimeType();
                id = item.getID().toString();
            }
            if (mimeType == null && (object = (DataObject)this.m_data.get("mimeType")) != null) {
                mimeType = (MimeType)DomainObjectFactory.newInstance((DataObject)object);
            }
            return ItemTemplatesListing.buildKey(useContext, id, mimeType);
        }
    }

    protected static class ItemTemplatesListingModelBuilder
    extends DataTable.DataBuilderAdapter {
        protected ItemTemplatesListingModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState s) {
            DataTable t = (DataTable)table;
            DataQuery d = this.createQuery(t, s);
            if (d == null) {
                return super.makeModel(table, s);
            }
            return new ItemTemplatesListingTableModel(t, d, t.getDataQueryBuilder().getKeyColumn());
        }
    }

    protected class PreviewCellRenderer
    implements TableCellRenderer {
        private ItemSelectionModel m_itemSel;

        public PreviewCellRenderer(ItemSelectionModel itemSel) {
            this.m_itemSel = itemSel;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            DataObject object;
            if (value == null) {
                return new Label("&nbsp;", false);
            }
            DataObject templateObject = (DataObject)ItemTemplatesListing.this.getDataQuery(state).get("template");
            MimeType mimeType = null;
            if (templateObject != null) {
                Template item = (Template)DomainObjectFactory.newInstance((DataObject)templateObject);
                mimeType = item.getMimeType();
            }
            if (mimeType == null && (object = (DataObject)ItemTemplatesListing.this.getDataQuery(state).get("mimeType")) != null) {
                mimeType = (MimeType)DomainObjectFactory.newInstance((DataObject)object);
            }
            if (mimeType != null && !"text/x-jsp".equals(mimeType.getMimeType())) {
                return new Label("&nbsp;", false);
            }
            String context = (String)value;
            ContentSection sec = CMS.getContext().getContentSection();
            ContentItem item = this.m_itemSel.getSelectedItem(state);
            Assert.assertNotNull((Object)item, (String)"item");
            ItemResolver res = sec.getItemResolver();
            String url = res.generateItemURL(state, item, sec, "preview", context);
            Link link = new Link((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.preview").localize() + " " + context), url);
            link.setIdAttr("previewInTable");
            return link;
        }
    }

    private static class MappingSelectionModel
    extends ACSObjectSelectionModel {
        private ItemSelectionModel m_itemSel;
        public static final String MAPPING_KEY = "c";

        public MappingSelectionModel(ItemSelectionModel itemSel) {
            super((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new StringParameter(MAPPING_KEY)));
            this.m_itemSel = itemSel;
        }

        public DomainObject getSelectedObject(PageState state) {
            Object key = this.getSelectedKey(state);
            BigDecimal id = null;
            if (key == null) {
                return null;
            }
            if (!this.isInitialized(state)) {
                if (!this.isSelected(state)) {
                    return null;
                }
                ACSObject item = this.loadACSObject(state, key);
                if (item == null) {
                    return null;
                }
                this.setSelectedObject(state, (DomainObject)item);
                this.setSelectedKey(state, key);
                ACSObjectCache.set((ServletRequest)state.getRequest(), (ACSObject)item);
                id = item.getID();
                return item;
            }
            return ACSObjectCache.get((ServletRequest)state.getRequest(), id);
        }

        public ACSObject loadACSObject(PageState state, Object key) {
            String context = ItemTemplatesListing.getUseContextFromKey((String)key);
            MimeType mimeType = ItemTemplatesListing.getMimeTypeFromKey((String)key);
            ContentItem item = this.m_itemSel.getSelectedItem(state);
            return ItemTemplateMapping.getMapping(item, context, mimeType);
        }
    }

    protected static class AssignCellRenderer
    implements TableCellRenderer {
        private static ControlLink s_link = new ControlLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.assign_template")));

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            return s_link;
        }

        static {
            s_link.setClassAttr("assignTemplateLink");
        }
    }
}

