/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.lifecycle;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.lifecycle.ItemPhaseTableModelBuilder;
import com.arsdigita.cms.ui.lifecycle.LifecycleRequestLocal;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

class ItemLifecycleItemPane
extends BaseItemPane {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/lifecycle/ItemLifecycleItemPane.java#13 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleItemPane == null ? (class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleItemPane = ItemLifecycleItemPane.class$("com.arsdigita.cms.ui.lifecycle.ItemLifecycleItemPane")) : class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleItemPane));
    private final ContentItemRequestLocal m_item;
    private final LifecycleRequestLocal m_lifecycle;
    private final SimpleContainer m_detailPane;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$lifecycle$ItemLifecycleItemPane;

    public ItemLifecycleItemPane(ContentItemRequestLocal item, LifecycleRequestLocal cycle) {
        this.m_item = item;
        this.m_lifecycle = cycle;
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        this.m_detailPane.add((Component)new SummarySection());
        this.m_detailPane.add((Component)new PhaseSection());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PhaseTable
    extends Table {
        PhaseTable() {
            super((TableModelBuilder)new ItemPhaseTableModelBuilder(ItemLifecycleItemPane.this.m_lifecycle), (Object[])new String[]{ItemLifecycleItemPane.lz("cms.ui.name"), ItemLifecycleItemPane.lz("cms.ui.description"), ItemLifecycleItemPane.lz("cms.ui.item.lifecycle.start_date"), ItemLifecycleItemPane.lz("cms.ui.item.lifecycle.end_date")});
        }
    }

    private class PhaseSection
    extends Section {
        PhaseSection() {
            super(ItemLifecycleItemPane.gz("cms.ui.lifecycle.phases"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new PhaseTable());
        }
    }

    private class UnpublishLink
    extends ActionLink {
        UnpublishLink() {
            super((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.unpublish")));
            this.addActionListener(new Listener());
        }

        private class Listener
        implements ActionListener {
            private Listener() {
            }

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                ContentItem item = ItemLifecycleItemPane.this.m_item.getContentItem(state);
                item.unpublish();
                String target = URL.getDispatcherPath() + ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB);
                throw new RedirectSignal(target, true);
            }
        }
    }

    private class SummarySection
    extends Section {
        public SummarySection() {
            this.setHeading((Component)new Label(ItemLifecycleItemPane.gz("cms.ui.lifecycle.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new UnpublishLink());
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                List props = super.properties(state);
                Lifecycle cycle = ItemLifecycleItemPane.this.m_lifecycle.getLifecycle(state);
                DateFormat format = DateFormat.getDateTimeInstance(0, ContentSection.getConfig().getHideTimezone() ? 3 : 0);
                props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.name"), cycle.getLabel()));
                props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.start_date"), format.format(cycle.getStartDate())));
                Date endDate = cycle.getEndDate();
                if (endDate == null) {
                    props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.end_date"), ItemLifecycleItemPane.lz("cms.ui.none")));
                } else {
                    props.add(new PropertyList.Property(ItemLifecycleItemPane.gz("cms.ui.item.lifecycle.end_date"), format.format(endDate)));
                }
                return props;
            }
        }
    }
}

