/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.CMSDHTMLEditor;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.SecurityPropertyEditor;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.AuthoringStepComponent;
import com.arsdigita.cms.ui.authoring.TextAssetBodyPropertySheet;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeStatus;
import com.arsdigita.mimetypes.TextMimeType;
import com.arsdigita.mimetypes.converters.ConvertFormat;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class TextAssetBody
extends SecurityPropertyEditor
implements Resettable,
AuthoringStepComponent,
RequestListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/TextAssetBody.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$TextAssetBody == null ? (class$com$arsdigita$cms$ui$authoring$TextAssetBody = TextAssetBody.class$("com.arsdigita.cms.ui.authoring.TextAssetBody")) : class$com$arsdigita$cms$ui$authoring$TextAssetBody));
    private ItemSelectionModel m_assetModel;
    public static final String FILE_UPLOAD = "file";
    public static final String TEXT_ENTRY = "text";
    private StringParameter m_streamlinedCreationParam;
    private static final String STREAMLINED = "_streamlined";
    private static final String STREAMLINED_DONE = "1";
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$TextAssetBody;

    public TextAssetBody(ItemSelectionModel assetModel) {
        this(assetModel, null);
    }

    public TextAssetBody(ItemSelectionModel assetModel, AuthoringKitWizard parent) {
        this.m_assetModel = assetModel;
        this.m_streamlinedCreationParam = new StringParameter(parent == null ? "item" : parent.getContentType().getAssociatedObjectType() + "_body_done");
        PageFileForm f = this.getPageFileForm();
        this.addFileWidgets(f);
        this.add(FILE_UPLOAD, "Upload a file", f, f.getSaveCancelSection().getCancelButton());
        PageTextForm t = new PageTextForm();
        this.addTextWidgets(t);
        this.add(TEXT_ENTRY, "Edit as text", t, t.getSaveCancelSection().getCancelButton());
        DomainObjectPropertySheet sheet = this.getBodyPropertySheet(assetModel);
        sheet.add("Text&nbsp;Type:", "mimeType.label");
        sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.body").localize(), "content");
        this.setDisplayComponent((Component)sheet);
        this.getDisplayPane().setClassAttr("invertedPropertyDisplay");
    }

    protected DomainObjectPropertySheet getBodyPropertySheet(ItemSelectionModel assetModel) {
        return new TextAssetBodyPropertySheet((DomainObjectSelectionModel)assetModel);
    }

    protected void setMimeTypeOptions(SingleSelect mimeSelect) {
        FileUploadSection.addMimeOptions((OptionGroup)mimeSelect, TEXT_ENTRY);
        mimeSelect.setOptionSelected("text/html");
    }

    public TextAsset getTextAsset(PageState state) {
        return (TextAsset)this.m_assetModel.getSelectedObject(state);
    }

    public void reset(PageState s) {
        this.showDisplayPane(s);
    }

    protected TextAsset createOrGetTextAsset(ItemSelectionModel assetModel, PageState s) {
        TextAsset t = this.getTextAsset(s);
        if (t == null) {
            t = this.createTextAsset(s);
            assetModel.setSelectedObject(s, (DomainObject)t);
        }
        return t;
    }

    protected abstract TextAsset createTextAsset(PageState var1);

    protected abstract void updateTextAsset(PageState var1, TextAsset var2);

    public ItemSelectionModel getAssetSelectionModel() {
        return this.m_assetModel;
    }

    protected void maybeForwardToNextStep(PageState state) {
        if (ContentItemPage.isStreamlinedCreationActive(state) && !STREAMLINED_DONE.equals(state.getValue((ParameterModel)this.m_streamlinedCreationParam))) {
            state.setValue((ParameterModel)this.m_streamlinedCreationParam, (Object)STREAMLINED_DONE);
            this.fireCompletionEvent(state);
        }
    }

    protected void cancelStreamlinedCreation(PageState state) {
        if (ContentItemPage.isStreamlinedCreationActive(state)) {
            state.setValue((ParameterModel)this.m_streamlinedCreationParam, (Object)STREAMLINED_DONE);
        }
    }

    public void pageRequested(RequestEvent e) {
        PageState state = e.getPageState();
        if (ContentItemPage.isStreamlinedCreationActive(state) && !STREAMLINED_DONE.equals(state.getValue((ParameterModel)this.m_streamlinedCreationParam))) {
            this.showComponent(state, TEXT_ENTRY);
        }
    }

    protected PageFileForm getPageFileForm() {
        return new PageFileForm();
    }

    protected String getDefaultMimeType() {
        return "text/plain";
    }

    protected void addFileWidgets(PageFileForm c) {
        c.m_fileUploadSection = new FileUploadSection("Text Type:", TEXT_ENTRY, this.getDefaultMimeType());
        c.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
        c.m_fileUploadSection.getMimeTypeWidget().setDefaultValue((Object)"-guess-");
        c.add((Component)c.m_fileUploadSection);
        c.m_saveCancelSection = new SaveCancelSection();
        c.add((Component)c.m_saveCancelSection);
        FormErrorDisplay fe = new FormErrorDisplay((Form)c);
        c.add((Component)fe);
        c.addValidationListener(c);
        c.addProcessListener(c);
        c.m_file_upload_content = new RequestLocal();
        c.m_file_upload_usedINSO = new RequestLocal();
    }

    protected void addTextWidgets(PageTextForm c) {
        ColumnPanel panel = (ColumnPanel)c.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "20%");
        panel.setColumnWidth(2, "80%");
        panel.setWidth("100%");
        c.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.text_type")));
        c.m_mimeWidget = new SingleSelect("mime_type");
        c.m_mimeWidget.setClassAttr("displayOneOptionAsLabel");
        this.setMimeTypeOptions(c.m_mimeWidget);
        c.add((Component)c.m_mimeWidget, 1);
        c.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.edit_body_text")), 65);
        c.m_textWidget = (TextArea)new CMSDHTMLEditor("text_entry");
        c.m_textWidget.setRows(25);
        c.m_textWidget.setCols(70);
        c.m_textWidget.setWrap(2);
        c.add((Component)c.m_textWidget, 65);
        c.m_saveCancelSection = new SaveCancelSection();
        c.add((Component)c.m_saveCancelSection, 64);
        c.addInitListener(c);
        c.addProcessListener(c);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_streamlinedCreationParam);
        p.addRequestListener((RequestListener)this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class PageTextForm
    extends Form
    implements FormInitListener,
    FormProcessListener,
    FormSubmissionListener {
        private SingleSelect m_mimeWidget;
        private Label m_mimeLabel;
        private TextArea m_textWidget;
        private SaveCancelSection m_saveCancelSection;
        public static final String TEXT_ENTRY = "text_entry";
        public static final String MIME_TYPE = "mime_type";

        public PageTextForm() {
            super("PageTextForm", (Container)new ColumnPanel(2));
            this.setMethod("post");
            this.setEncType("multipart/form-data");
        }

        public final void setMimeWidget(SingleSelect widget) {
            this.m_mimeWidget = widget;
        }

        public final void setTextWidget(TextArea widget) {
            this.m_textWidget = widget;
        }

        public final void setSaveCancel(SaveCancelSection widget) {
            this.m_saveCancelSection = widget;
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            TextAsset t = (TextAsset)TextAssetBody.this.m_assetModel.getSelectedObject(state);
            if (t != null) {
                data.put((Object)TEXT_ENTRY, (Object)t.getText());
                MimeType m = t.getMimeType();
                if (m != null) {
                    data.put((Object)MIME_TYPE, (Object)m.getMimeType());
                }
            }
        }

        public void submitted(FormSectionEvent e) {
            if (this.getSaveCancelSection().getCancelButton().isSelected(e.getPageState())) {
                TextAssetBody.this.cancelStreamlinedCreation(e.getPageState());
            }
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            TextAsset t = TextAssetBody.this.createOrGetTextAsset(TextAssetBody.this.m_assetModel, state);
            MimeType m = MimeType.loadMimeType((String)((String)data.get((Object)MIME_TYPE)));
            t.setMimeType(m);
            String text = (String)data.get((Object)TEXT_ENTRY);
            if (text == null) {
                text = "";
            }
            t.setText((String)data.get((Object)TEXT_ENTRY));
            TextAssetBody.this.updateTextAsset(state, t);
            if (t.isNew() || t.isModified()) {
                t.save();
            }
            TextAssetBody.this.maybeForwardToNextStep(e.getPageState());
        }

        public SaveCancelSection getSaveCancelSection() {
            return this.m_saveCancelSection;
        }
    }

    public class PageFileForm
    extends Form
    implements FormProcessListener,
    FormValidationListener {
        private SaveCancelSection m_saveCancelSection;
        private FileUploadSection m_fileUploadSection;
        private RequestLocal m_file_upload_content;
        private RequestLocal m_file_upload_usedINSO;
        public static final String TEXT_ENTRY = "text_entry";

        public PageFileForm() {
            super("PageFileUpload", (Container)new BoxPanel(2));
            this.setMethod("post");
            this.setEncType("multipart/form-data");
        }

        protected String getFileUploadContent(PageState state) {
            return (String)this.m_file_upload_content.get(state);
        }

        private void validateFileType(MimeType mime, boolean textType) throws FormProcessException {
            boolean insoWorks;
            boolean validType;
            boolean bl = validType = textType || mime instanceof TextMimeType && ((TextMimeType)mime).allowINSOConvert() != false;
            if (!validType) {
                throw new FormProcessException("Cannot load files of type " + mime.getMimeType() + " into the article body.");
            }
            boolean bl2 = insoWorks = MimeTypeStatus.getMimeTypeStatus().getInsoFilterWorks().intValue() == 1;
            if (!textType && !insoWorks) {
                throw new FormProcessException("Could not convert to html format because interMedia INSO filter is not installed.");
            }
        }

        private byte[] readFileBytes(File file) throws FormProcessException {
            byte[] file_bytes;
            try {
                FileInputStream fs = new FileInputStream(file);
                file_bytes = new byte[fs.available()];
                fs.read(file_bytes);
                fs.close();
            }
            catch (Exception e) {
                throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.unable_to_load_file").localize() + e.getMessage());
            }
            return file_bytes;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String convertBytes(byte[] file_bytes, boolean text_type, boolean[] used_inso) throws FormProcessException {
            String file_content;
            if (!text_type) {
                file_content = ConvertFormat.toHTML((byte[])file_bytes);
                if (file_content == null) throw new FormProcessException("Could not convert to html format. interMedia INSO filter conversion failed.");
                used_inso[0] = true;
                return file_content;
            }
            String enc = Globalization.getDefaultCharset((Locale)Kernel.getContext().getLocale());
            try {
                file_content = new String(file_bytes, enc);
            }
            catch (UnsupportedEncodingException ex) {
                throw new UncheckedWrapperException("cannot convert to encoding " + enc, (Throwable)ex);
            }
            used_inso[0] = false;
            return file_content;
        }

        private String extractHTMLBody(String htmlText) throws FormProcessException {
            String lc = htmlText.toLowerCase();
            int bodyStart = lc.indexOf("<body");
            int bodyStart_v = lc.indexOf(">", bodyStart);
            int bodyEnd = lc.indexOf("</body>", bodyStart_v);
            if (bodyStart == -1 || bodyEnd == -1) {
                String errMsg = "The file (which should be type HTML) is missing the <body> or </body> tag.";
                throw new FormProcessException("The file (which should be type HTML) is missing the <body> or </body> tag.");
            }
            return htmlText.substring(bodyStart_v + 1, bodyEnd);
        }

        public void validate(FormSectionEvent e) throws FormProcessException {
            MimeType mime = this.m_fileUploadSection.getMimeType(e);
            boolean textType = mime.getPrefix().equals(TextAssetBody.TEXT_ENTRY);
            this.validateFileType(mime, textType);
            File file = this.m_fileUploadSection.getFile(e);
            byte[] file_bytes = this.readFileBytes(file);
            boolean[] used_inso = new boolean[1];
            String file_content = this.convertBytes(file_bytes, textType, used_inso);
            if ("text/html".equals(mime.getMimeType())) {
                file_content = this.extractHTMLBody(file_content);
            }
            PageState state = e.getPageState();
            this.m_file_upload_content.set(state, (Object)file_content);
            this.m_file_upload_usedINSO.set(state, (Object)new Boolean(used_inso[0]));
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            TextAsset t = TextAssetBody.this.createOrGetTextAsset(TextAssetBody.this.m_assetModel, state);
            File file = this.m_fileUploadSection.getFile(e);
            String upload_content = (String)this.m_file_upload_content.get(state);
            boolean usedINSO = (Boolean)this.m_file_upload_usedINSO.get(state);
            MimeType mime = this.m_fileUploadSection.getMimeType(e);
            if (usedINSO) {
                mime = MimeType.loadMimeType((String)"text/html");
            }
            if (mime != null) {
                t.setMimeType(mime);
            }
            t.setText(upload_content);
            file = null;
            TextAssetBody.this.updateTextAsset(state, t);
            if (t.isNew() || t.isModified()) {
                t.save();
            }
        }

        public SaveCancelSection getSaveCancelSection() {
            return this.m_saveCancelSection;
        }

        public FileUploadSection getFileUploadSection() {
            return this.m_fileUploadSection;
        }
    }
}

