/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public abstract class NewItemForm
extends Form {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/NewItemForm.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String RESOURCE_BUNDLE = "com.arsdigita.cms.ui.authoring.AuthoringResources";
    public static String DP_TYPE_PREFIX = "com.arsdigita.dp.";
    private SingleSelect m_typeWidget;
    private Submit m_submit;
    private Label m_emptyLabel;
    private Label m_createLabel;
    public static final String TYPE_ID = "tid";

    public NewItemForm(String name) {
        super(name, (Container)new BoxPanel(1));
        this.setIdAttr("new_item_form");
        BoxPanel panel = (BoxPanel)this.getPanel();
        panel.setWidth("2%");
        panel.setBorder(0);
        this.m_emptyLabel = new Label(NewItemForm.globalize("cms.ui.authoring.no_types_registered"), false);
        this.m_emptyLabel.setIdAttr("empty_label");
        this.add((Component)this.m_emptyLabel);
        this.m_createLabel = new Label(NewItemForm.globalize("cms.ui.authoring.create_new"), false);
        this.m_createLabel.setIdAttr("create_label");
        this.add((Component)this.m_createLabel);
        this.m_typeWidget = new SingleSelect((ParameterModel)new BigDecimalParameter(TYPE_ID));
        try {
            this.m_typeWidget.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent e) {
                    OptionGroup o = (OptionGroup)e.getTarget();
                    PageState state = e.getPageState();
                    ContentSection section = NewItemForm.this.getContentSection(state);
                    ContentTypeCollection c = section.getCreatableContentTypes();
                    c.addOrder("label");
                    if (!c.isEmpty()) {
                        while (c.next()) {
                            ContentType type = c.getContentType();
                            String cn = type.getClassName();
                            String l = type.getLabel();
                            if (cn.startsWith(DP_TYPE_PREFIX, 0)) {
                                o.addOption(new Option(type.getID().toString(), (Component)new Label(NewItemForm.globalize(l.replace(' ', '_')))));
                                continue;
                            }
                            o.addOption(new Option(type.getID().toString(), type.getLabel()));
                        }
                        c.reset();
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("Too  many listeners: " + e.getMessage(), (Throwable)e);
        }
        this.add((Component)this.m_typeWidget);
        this.m_submit = new Submit("new", NewItemForm.globalize("cms.ui.authoring.go"));
        this.add((Component)this.m_submit);
    }

    public abstract ContentSection getContentSection(PageState var1);

    public BigDecimal getTypeID(PageState state) {
        return (BigDecimal)this.m_typeWidget.getValue(state);
    }

    public final SingleSelect getTypeSelect() {
        return this.m_typeWidget;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            ContentSection section = this.getContentSection(state);
            ContentTypeCollection c = section.getCreatableContentTypes();
            boolean isEmpty = c.isEmpty();
            c.close();
            this.m_createLabel.setVisible(state, !isEmpty);
            this.m_typeWidget.setVisible(state, !isEmpty);
            this.m_submit.setVisible(state, !isEmpty);
            this.m_emptyLabel.setVisible(state, isEmpty);
            super.generateXML(state, parent);
        }
    }

    public static GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, RESOURCE_BUNDLE);
    }
}

