/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.ContentSectionContainer;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class TasksPanel
extends CMSContainer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/TasksPanel.java#21 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$TasksPanel == null ? (class$com$arsdigita$cms$ui$TasksPanel = TasksPanel.class$("com.arsdigita.cms.ui.TasksPanel")) : class$com$arsdigita$cms$ui$TasksPanel));
    private static final int DEFAULT_MAX_ROWS = 15;
    private final int m_maxRows;
    private TaskList m_taskList;
    private ActionLink m_viewAllLink;
    private ActionLink m_viewShortLink;
    private Paginator m_paginator;
    private ActionLink m_viewLockLink;
    private ActionLink m_viewUnlockLink;
    private ActionLink m_viewAllLockLink;
    private Label m_viewLockLabel;
    private Label m_viewUnlockLabel;
    private Label m_viewAllLockLabel;
    private Label m_actionLabel;
    private StringParameter m_sortDirectionParam;
    private StringParameter m_sortTypeParam;
    private StringParameter m_lockFilterParam;
    private static final String ACTION = "taskAction";
    private static final String SORT_ACTION_DOWN = "sortActionUp";
    private static final String SORT_ACTION_UP = "sortActionDown";
    public static final String LOCK_FILTER_TYPE = "lockFilterType";
    public static final String SORT_TYPE = "sortType";
    public static final String SORT_DIRECTION = "sortDirection";
    public static final String SORT_USER = "user";
    public static final String SORT_TITLE = "title";
    public static final String SORT_DATE = "date";
    public static final String SORT_STATUS = "status";
    public static final String UP_ARROW_IMAGE = "/assets/gray-triangle-up.gif";
    public static final String DOWN_ARROW_IMAGE = "/assets/gray-triangle-down.gif";
    private Label m_selectorLabel;
    private CreationSelector m_selector;
    private ContentSectionContainer m_sections;
    private ACSObjectSelectionModel m_sectionSel;
    private ACSObjectSelectionModel m_typeSel;
    private RootFolderSelectionModel m_folderSel;
    private BoxPanel m_creationPane;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$TasksPanel;

    public TasksPanel(ACSObjectSelectionModel typeModel, ACSObjectSelectionModel sectionModel) {
        this(15, typeModel, sectionModel);
    }

    public TasksPanel(int maxRows, ACSObjectSelectionModel typeModel, ACSObjectSelectionModel sectionModel) {
        this.m_maxRows = maxRows;
        this.m_typeSel = typeModel;
        this.m_sectionSel = sectionModel;
        this.m_sortDirectionParam = new StringParameter(SORT_DIRECTION);
        this.m_sortTypeParam = new StringParameter(SORT_TYPE);
        this.m_lockFilterParam = new StringParameter(LOCK_FILTER_TYPE);
        this.addComponents();
    }

    protected void addComponents() {
        this.m_creationPane = new BoxPanel(2);
        this.m_selectorLabel = new Label(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label t = (Label)e.getTarget();
                ContentType type = (ContentType)TasksPanel.this.m_typeSel.getSelectedObject(s);
                ContentSection sec = (ContentSection)TasksPanel.this.m_sectionSel.getSelectedObject(s);
                StringBuffer buf = new StringBuffer(GlobalizationUtil.globalize("cms.ui.create").localize() + " ");
                buf.append(type.getLabel());
                buf.append(" in ");
                buf.append(sec.getName());
                t.setLabel(buf.toString());
                t.setFontWeight("b");
                t.setClassAttr("creationLabel");
            }
        });
        this.m_selectorLabel.setClassAttr("creationLabel");
        this.m_creationPane.add((Component)this.m_selectorLabel);
        this.m_folderSel = new RootFolderSelectionModel(this.m_sectionSel);
        this.m_selector = new CreationSelector((SingleSelectionModel)this.m_typeSel, this.m_folderSel);
        this.m_creationPane.add((Component)this.m_selector);
        this.m_creationPane.setClassAttr("itemCreationPane");
        this.add((Component)this.m_creationPane);
        this.m_sections = new ContentSectionContainer((SingleSelectionModel)this.m_typeSel, (SingleSelectionModel)this.m_sectionSel);
        this.add((Component)this.m_sections);
        this.m_typeSel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState s = e.getPageState();
                boolean isSelected = TasksPanel.this.m_typeSel.isSelected(s);
                TasksPanel.this.m_sections.setVisible(s, !isSelected);
                TasksPanel.this.m_creationPane.setVisible(s, isSelected);
            }
        });
        this.m_viewLockLink = new ActionLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_locked")));
        this.m_viewLockLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                ps.setValue((ParameterModel)TasksPanel.this.m_lockFilterParam, (Object)"lock");
            }
        });
        this.m_viewUnlockLink = new ActionLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_unlocked")));
        this.m_viewUnlockLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                ps.setValue((ParameterModel)TasksPanel.this.m_lockFilterParam, (Object)"unlock");
            }
        });
        this.m_viewAllLockLink = new ActionLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_all")));
        this.m_viewAllLockLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                ps.setValue((ParameterModel)TasksPanel.this.m_lockFilterParam, (Object)"all");
            }
        });
        this.m_viewLockLabel = new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_locked"));
        this.m_viewLockLabel.setFontWeight("b");
        this.m_viewUnlockLabel = new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_unlocked"));
        this.m_viewUnlockLabel.setFontWeight("b");
        this.m_viewAllLockLabel = new Label(GlobalizationUtil.globalize("cms.ui.workflow.task.view_all"));
        this.m_viewAllLockLabel.setFontWeight("b");
        this.add((Component)new Label("<br />", false));
        this.add((Component)this.m_viewLockLink);
        this.add((Component)this.m_viewLockLabel);
        this.add((Component)new Label("&nbsp;", false));
        this.add((Component)this.m_viewUnlockLink);
        this.add((Component)this.m_viewUnlockLabel);
        this.add((Component)new Label("&nbsp;", false));
        this.add((Component)this.m_viewAllLockLink);
        this.add((Component)this.m_viewAllLockLabel);
        this.add((Component)new Label("<br />", false));
        this.add((Component)new Label("<br />", false));
        this.add((Component)this.getTasksList());
        this.add((Component)this.getPaginator());
        this.m_actionLabel = new Label(GlobalizationUtil.globalize("cms.ui.action"));
        this.m_actionLabel.setClassAttr("action");
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_creationPane, false);
        p.addComponentStateParam((Component)this, this.m_folderSel.getStateParameter());
        p.addGlobalStateParam((ParameterModel)this.m_lockFilterParam);
        p.addGlobalStateParam((ParameterModel)this.m_sortTypeParam);
        p.addGlobalStateParam((ParameterModel)this.m_sortDirectionParam);
        p.setVisibleDefault((Component)this.m_viewLockLabel, false);
        p.setVisibleDefault((Component)this.m_viewUnlockLabel, false);
        p.setVisibleDefault((Component)this.m_viewAllLockLink, false);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String lockFilterType = TasksPanel.this.getLockFilterType(state);
                if (lockFilterType.equals("lock")) {
                    TasksPanel.this.m_viewLockLabel.setVisible(state, true);
                    TasksPanel.this.m_viewLockLink.setVisible(state, false);
                    TasksPanel.this.m_viewUnlockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewUnlockLink.setVisible(state, true);
                    TasksPanel.this.m_viewAllLockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewAllLockLink.setVisible(state, true);
                } else if (lockFilterType.equals("unlock")) {
                    TasksPanel.this.m_viewLockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewLockLink.setVisible(state, true);
                    TasksPanel.this.m_viewUnlockLabel.setVisible(state, true);
                    TasksPanel.this.m_viewUnlockLink.setVisible(state, false);
                    TasksPanel.this.m_viewAllLockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewAllLockLink.setVisible(state, true);
                } else {
                    TasksPanel.this.m_viewLockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewLockLink.setVisible(state, true);
                    TasksPanel.this.m_viewUnlockLabel.setVisible(state, false);
                    TasksPanel.this.m_viewUnlockLink.setVisible(state, true);
                    TasksPanel.this.m_viewAllLockLabel.setVisible(state, true);
                    TasksPanel.this.m_viewAllLockLink.setVisible(state, false);
                }
            }
        });
    }

    public void reset(PageState state) {
        this.m_typeSel.clearSelection(state);
        this.m_sectionSel.clearSelection(state);
    }

    protected Paginator getPaginator() {
        if (this.m_paginator == null) {
            this.m_paginator = new Paginator((PaginationModelBuilder)new TasksPaginationModelBuilder(), this.m_maxRows);
        }
        return this.m_paginator;
    }

    private TaskList getTasksList() {
        if (this.m_taskList == null) {
            this.m_taskList = new TaskList(true);
        }
        return this.m_taskList;
    }

    protected int numberTasksForUser(PageState state) {
        return this.m_taskList.size(state);
    }

    protected String getSortType(PageState state) {
        String sortType = (String)state.getValue((ParameterModel)this.m_sortTypeParam);
        if (sortType == null) {
            sortType = SORT_DATE;
        }
        return sortType;
    }

    protected String getSortDirection(PageState state) {
        String sortDirection = (String)state.getValue((ParameterModel)this.m_sortDirectionParam);
        if (sortDirection == null) {
            sortDirection = SORT_ACTION_UP;
        }
        return sortDirection;
    }

    protected String getLockFilterType(PageState state) {
        String lockFilterType = (String)state.getValue((ParameterModel)this.m_lockFilterParam);
        if (lockFilterType == null || lockFilterType.equals("")) {
            lockFilterType = "";
        }
        return lockFilterType;
    }

    protected void addQueryFilters(DataQuery query, Party party, PageState state) {
        query.setParameter("userId", (Object)party.getID());
        FilterFactory ff = query.getFilterFactory();
        CompoundFilter authorFilter = ff.and();
        authorFilter.addFilter(ff.equals("taskType", (Object)"Author"));
        authorFilter.addFilter(TasksPanel.getTaskFilter("Author", party, ff));
        CompoundFilter approveFilter = ff.and();
        approveFilter.addFilter(ff.equals("taskType", (Object)"Edit"));
        approveFilter.addFilter(TasksPanel.getTaskFilter("Edit", party, ff));
        CompoundFilter deployFilter = ff.and();
        deployFilter.addFilter(ff.equals("taskType", (Object)"Deploy"));
        deployFilter.addFilter(TasksPanel.getTaskFilter("Deploy", party, ff));
        CompoundFilter permissionFilter = ff.or();
        permissionFilter.addFilter((Filter)authorFilter);
        permissionFilter.addFilter((Filter)approveFilter);
        permissionFilter.addFilter((Filter)deployFilter);
        query.addFilter((Filter)permissionFilter);
        String lockFilterType = this.getLockFilterType(state);
        if (lockFilterType.equals("lock")) {
            query.addEqualsFilter("isLocked", (Object)"t");
            query.addEqualsFilter(SORT_STATUS, (Object)"1");
        } else if (lockFilterType.equals("unlock")) {
            query.addEqualsFilter("isLocked", (Object)"f");
        }
    }

    private static Filter getTaskFilter(String taskType, Party party, FilterFactory factory) {
        PrivilegeDescriptor privilege;
        OID partyOID = party.getOID();
        if (taskType.equals("Deploy")) {
            String queryType = "deploy";
            privilege = new PrivilegeDescriptor("cms_publish");
        } else {
            String queryType = "edit";
            privilege = new PrivilegeDescriptor("cms_edit_item");
        }
        return PermissionService.getFilterQuery((FilterFactory)factory, (String)"itemID", (PrivilegeDescriptor)privilege, (OID)partyOID);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TaskList
    extends SimpleComponent {
        private static final String QUERY_NAME = "com.arsdigita.cms.workflow.getEnabledUserTasks";
        private boolean m_paginate = false;
        private RequestLocal m_taskCount = new RequestLocal(this){
            private final /* synthetic */ TaskList this$1;
            {
                this.this$1 = this$1;
            }

            public Object initialValue(PageState state) {
                DataQuery query = TaskList.access$1300(this.this$1, state);
                return new Long(query.size());
            }
        };

        public TaskList(boolean paginate) {
            this.m_paginate = paginate;
        }

        private DataQuery makeQuery(PageState state) {
            User user = (User)Kernel.getContext().getParty();
            DataQuery query = SessionManager.getSession().retrieveQuery(QUERY_NAME);
            TasksPanel.this.addQueryFilters(query, (Party)user, state);
            return query;
        }

        public int size(PageState ps) {
            return ((Long)this.m_taskCount.get(ps)).intValue();
        }

        public void generateXML(PageState state, Element parent) {
            Element content = parent.newChildElement("cms:tasksPanel", "http://www.arsdigita.com/cms/1.0");
            this.exportAttributes(content);
            DataQuery query = this.makeQuery(state);
            String lockFilterType = TasksPanel.this.getLockFilterType(state);
            content.addAttribute(TasksPanel.LOCK_FILTER_TYPE, lockFilterType);
            if (this.m_paginate) {
                query.setRange(new Integer(TasksPanel.this.m_paginator.getFirst(state)), new Integer(TasksPanel.this.m_paginator.getLast(state) + 1));
            }
            String sortKey = TasksPanel.this.getSortType(state);
            String sortDirection = TasksPanel.this.getSortDirection(state);
            String sortPostfix = " asc";
            if (sortDirection.equals(TasksPanel.SORT_ACTION_DOWN)) {
                sortPostfix = " desc";
            }
            if (sortKey.equals(TasksPanel.SORT_TITLE)) {
                query.setOrder("lower(pageTitle) " + sortPostfix + ", lower(status) asc, dueDate desc");
            } else if (sortKey.equals(TasksPanel.SORT_DATE)) {
                query.setOrder("dueDate " + sortPostfix + ", lower(status) asc, lower(pageTitle) asc");
            } else if (sortKey.equals(TasksPanel.SORT_USER)) {
                query.setOrder("lockingUserID " + sortPostfix + ", lower(status) asc, dueDate desc, " + " lower(pageTitle) asc");
            } else if (sortKey.equals(TasksPanel.SORT_STATUS)) {
                query.setOrder("lower(status) " + sortPostfix + ", dueDate desc, " + " lower(pageTitle) asc");
            }
            HashMap<BigDecimal, String> sections = new HashMap<BigDecimal, String>();
            while (query.next()) {
                BigDecimal sectionID = (BigDecimal)query.get("sectionID");
                String sectionPath = (String)sections.get(sectionID);
                if (sectionPath == null) {
                    try {
                        ContentSection section = (ContentSection)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentSection", (Object)sectionID));
                        sectionPath = section.getPath();
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw new UncheckedWrapperException("cannot find content section", (Throwable)ex);
                    }
                    sections.put(sectionID, sectionPath);
                }
                Element task = content.newChildElement("cms:tasksPanelTask", "http://www.arsdigita.com/cms/1.0");
                BigDecimal itemID = (BigDecimal)query.get("itemID");
                String taskType = (String)query.get("taskType");
                task.addAttribute("taskID", query.get("taskID").toString());
                task.addAttribute("processID", query.get("processID").toString());
                task.addAttribute("taskLabel", (String)query.get("taskLabel"));
                task.addAttribute("taskDescription", (String)query.get("taskDescription"));
                String isLocked = (String)query.get("isLocked");
                task.addAttribute("isLocked", isLocked);
                if (query.get("dueDate") != null) {
                    Date d = (Date)query.get("dueDate");
                    SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy");
                    task.addAttribute("dueDate", df.format(d));
                }
                task.addAttribute("itemID", itemID.toString());
                task.addAttribute("sectionID", query.get("sectionID").toString());
                task.addAttribute("sectionPath", sectionPath);
                task.addAttribute("pageName", (String)query.get("pageName"));
                task.addAttribute("pageTitle", (String)query.get("pageTitle"));
                BigDecimal lockingUserID = (BigDecimal)query.get("lockingUserID");
                if (lockingUserID != null) {
                    User lockingUser;
                    task.addAttribute("lockingUserID", lockingUserID.toString());
                    if (!"f".equals(isLocked) && (lockingUser = User.retrieve((BigDecimal)lockingUserID)) != null) {
                        task.addAttribute("assignee", lockingUser.getDisplayName());
                    }
                }
                task.addAttribute("taskType", taskType);
                task.addAttribute("taskTypeClass", (String)query.get("taskTypeClass"));
                task.addAttribute(TasksPanel.SORT_STATUS, query.get(TasksPanel.SORT_STATUS).toString());
                try {
                    state.setControlEvent((Component)this, TasksPanel.ACTION, itemID.toString());
                    task.addAttribute("actionURL", state.stateAsURL());
                    state.clearControlEvent();
                }
                catch (IOException ex) {
                    s_log.warn((Object)("Error: " + ex.getMessage()));
                }
                if ("Deploy".equals(taskType)) {
                    task.addAttribute("editTabNumber", String.valueOf(ContentItemPage.PUBLISHING_TAB));
                    continue;
                }
                task.addAttribute("editTabNumber", String.valueOf(ContentItemPage.AUTHORING_TAB));
            }
            TasksPanel.this.m_actionLabel.generateXML(state, content);
            String[][] sortableHeaders = new String[][]{{TasksPanel.SORT_TITLE, "cms.ui.workflow.task.item_title"}, {TasksPanel.SORT_DATE, "cms.tasks.ui.due_date"}, {TasksPanel.SORT_STATUS, "cms.tasks.ui.status_no_colon"}, {TasksPanel.SORT_USER, "cms.ui.workflow.task.locking_user"}};
            for (int i = 0; i < sortableHeaders.length; ++i) {
                String header = sortableHeaders[i][0];
                String labelKey = sortableHeaders[i][1];
                if (sortDirection.equals(TasksPanel.SORT_ACTION_UP) && header.equals(sortKey)) {
                    state.setControlEvent((Component)this, TasksPanel.SORT_ACTION_DOWN, header);
                } else {
                    state.setControlEvent((Component)this, TasksPanel.SORT_ACTION_UP, header);
                }
                SimpleContainer container = new SimpleContainer();
                container.add((Component)new Label(GlobalizationUtil.globalize(labelKey)));
                if (header.equals(sortKey)) {
                    String imageURLStub = null;
                    imageURLStub = TasksPanel.SORT_ACTION_UP.equals(sortDirection) ? TasksPanel.UP_ARROW_IMAGE : TasksPanel.DOWN_ARROW_IMAGE;
                    Image image = new Image(imageURLStub);
                    image.setBorder("0");
                    container.add((Component)image);
                }
                ControlLink link = new ControlLink((Component)container);
                link.setClassAttr(header);
                link.generateXML(state, content);
                state.clearControlEvent();
            }
        }

        public void respond(PageState state) throws ServletException {
            String key = state.getControlEventName();
            String value = state.getControlEventValue();
            if (TasksPanel.ACTION.equals(key)) {
                BigDecimal itemID = new BigDecimal(value);
                try {
                    ContentItem item = new ContentItem(itemID);
                    Workflow wf = Workflow.getObjectWorkflow((ACSObject)item);
                    int tabNumber = ContentItemPage.AUTHORING_TAB;
                    String sectionPath = item.getContentSection().getPath();
                    if (wf != null) {
                        User user = Web.getContext().getUser();
                        Engine engine = Engine.getInstance();
                        Iterator i = engine.getEnabledTasks(user, wf.getID()).iterator();
                        if (i.hasNext()) {
                            CMSTask task = (CMSTask)((Object)i.next());
                            BigDecimal taskType = task.getTaskType();
                            if (taskType.equals(CMSTask.DEPLOY)) {
                                tabNumber = ContentItemPage.PUBLISHING_TAB;
                            } else if (!task.isLocked()) {
                                task.lock(user);
                            }
                        }
                    }
                    String redirectURL = Web.getConfig().getDispatcherServletPath() + sectionPath + "/admin/item.jsp?item_id=" + itemID + "&set_tab=" + tabNumber;
                    throw new RedirectSignal(redirectURL, true);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new ServletException("Unknown content ID" + itemID);
                }
            }
            if (TasksPanel.SORT_ACTION_UP.equals(key) || TasksPanel.SORT_ACTION_DOWN.equals(key)) {
                state.setValue((ParameterModel)TasksPanel.this.m_sortTypeParam, (Object)value);
                if (TasksPanel.SORT_ACTION_DOWN.equals(key)) {
                    state.setValue((ParameterModel)TasksPanel.this.m_sortDirectionParam, (Object)TasksPanel.SORT_ACTION_DOWN);
                } else {
                    state.setValue((ParameterModel)TasksPanel.this.m_sortDirectionParam, (Object)TasksPanel.SORT_ACTION_UP);
                }
            } else {
                throw new ServletException("Unknown control event: " + key);
            }
        }

        static /* synthetic */ DataQuery access$1300(TaskList x0, PageState x1) {
            return x0.makeQuery(x1);
        }
    }

    private class TasksPaginationModelBuilder
    implements PaginationModelBuilder {
        private TasksPaginationModelBuilder() {
        }

        public int getTotalSize(Paginator paginator, PageState state) {
            return TasksPanel.this.numberTasksForUser(state);
        }

        public boolean isVisible(PageState state) {
            return TasksPanel.this.numberTasksForUser(state) > TasksPanel.this.m_maxRows;
        }
    }

    private static class RootFolderSelectionModel
    extends FolderSelectionModel {
        ACSObjectSelectionModel m_sectionSel;

        public RootFolderSelectionModel(ACSObjectSelectionModel sectionSel) {
            super("f");
            this.m_sectionSel = sectionSel;
        }

        protected BigDecimal getRootFolderID(PageState s) {
            Folder folder;
            ContentSection sec = (ContentSection)this.m_sectionSel.getSelectedObject(s);
            Assert.assertNotNull((Object)((Object)sec));
            User user = Web.getContext().getUser();
            if (user != null && (folder = Folder.getUserHomeFolder(user, sec)) != null) {
                return folder.getID();
            }
            return sec.getRootFolder().getID();
        }
    }
}

