/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.ui.ItemSearchBrowsePane;
import com.arsdigita.cms.ui.ItemSearchPopup;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ItemSearchPage
extends CMSPage {
    private static final String XSL_CLASS = "CMS Admin";
    private TabbedPane m_tabbedPane;
    private ItemSearchBrowsePane m_browse;
    private ItemSearchPopup m_search;
    private BigDecimalParameter m_sectionId;
    public static final String CONTENT_SECTION = "section_id";

    public ItemSearchPage() {
        super("Item Search", (Container)new SimpleContainer());
        this.setClassAttr("cms-admin");
        this.addGlobalStateParam((ParameterModel)new BigDecimalParameter("single_type"));
        this.addGlobalStateParam((ParameterModel)new StringParameter("widget"));
        this.m_sectionId = new BigDecimalParameter(CONTENT_SECTION);
        this.addGlobalStateParam((ParameterModel)this.m_sectionId);
        this.m_browse = this.getBrowsePane();
        this.m_search = this.getSearchPane();
        this.m_tabbedPane = this.createTabbedPane();
        this.m_tabbedPane.setIdAttr("page-body");
        this.add((Component)this.m_tabbedPane);
    }

    protected ItemSearchBrowsePane getBrowsePane() {
        if (this.m_browse == null) {
            this.m_browse = new ItemSearchBrowsePane();
        }
        return this.m_browse;
    }

    protected ItemSearchPopup getSearchPane() {
        if (this.m_search == null) {
            this.m_search = new ItemSearchPopup("draft");
        }
        return this.m_search;
    }

    protected TabbedPane createTabbedPane() {
        TabbedPane pane = new TabbedPane();
        pane.setClassAttr(XSL_CLASS);
        this.addToPane(pane, "Browse", (Component)this.getBrowsePane());
        this.addToPane(pane, "Search", (Component)this.getSearchPane());
        pane.setDefaultPane((Component)this.m_browse);
        return pane;
    }

    protected void addToPane(TabbedPane pane, String tabName, Component comp) {
        if (comp != null) {
            pane.addTab(tabName, comp);
        }
    }

    public void dispatch(final HttpServletRequest request, final HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        new CMSExcursion(){

            public void excurse() throws IOException, ServletException {
                ContentSection section = null;
                Application app = Web.getContext().getApplication();
                if (app instanceof ContentSection) {
                    section = (ContentSection)app;
                } else {
                    try {
                        section = new ContentSection((BigDecimal)ItemSearchPage.this.m_sectionId.transformValue(request));
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw new UncheckedWrapperException((Throwable)ex);
                    }
                }
                this.setContentSection(section);
                Document doc = ItemSearchPage.this.buildDocument(request, response);
                PresentationManager pm = Templating.getPresentationManager();
                pm.servePage(doc, request, response);
            }
        }.run();
    }
}

