/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PropertySheet;
import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.bebop.PropertySheetModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainService;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.LockableImpl;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ItemPropertySheet
extends PropertySheet {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ItemPropertySheet.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private List m_props;
    private ItemSelectionModel m_itemModel;
    private AttributeFormatter m_toStringFormatter;
    private AttributeFormatter m_recursiveFormatter;

    public ItemPropertySheet(ItemSelectionModel itemModel) {
        super((PropertySheetModelBuilder)new ItemModelBuilder());
        this.m_itemModel = itemModel;
        this.m_props = new LinkedList();
        this.m_toStringFormatter = new SimpleAttributeFormatter();
        this.m_recursiveFormatter = new RecursiveAttributeFormatter();
        this.getColumn(0).setVAlign("top");
        this.getColumn(0).setAlign("left");
        this.getColumn(1).setVAlign("top");
        this.getColumn(1).setAlign("left");
    }

    public ItemPropertySheet(ItemSelectionModel itemModel, boolean valueOutputEscape) {
        super((PropertySheetModelBuilder)new ItemModelBuilder(), valueOutputEscape);
        this.m_itemModel = itemModel;
        this.m_props = new LinkedList();
        this.m_toStringFormatter = new SimpleAttributeFormatter();
        this.m_recursiveFormatter = new RecursiveAttributeFormatter();
        this.getColumn(0).setVAlign("top");
        this.getColumn(0).setAlign("left");
        this.getColumn(1).setVAlign("top");
        this.getColumn(1).setAlign("left");
    }

    public void add(String label, String attribute) {
        this.add(GlobalizationUtil.globalize(label), attribute);
    }

    public void add(GlobalizedMessage label, String attribute) {
        if (attribute.indexOf(46) == -1) {
            this.add(label, attribute, this.m_toStringFormatter);
        } else {
            this.add(label, attribute, this.m_recursiveFormatter);
        }
    }

    public void add(String label, String attribute, AttributeFormatter f) {
        this.add(GlobalizationUtil.globalize(label), attribute, f);
    }

    public void add(GlobalizedMessage label, String attribute, AttributeFormatter f) {
        this.m_props.add(new Property(label, attribute, f));
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    protected Iterator properties() {
        return this.m_props.iterator();
    }

    private static class RecursiveAttributeFormatter
    extends DefaultAttributeFormatter {
        public RecursiveAttributeFormatter() {
        }

        public RecursiveAttributeFormatter(String def) {
            super(def);
        }

        public String format(ContentItem item, String attribute, PageState state) {
            StringTokenizer tokenizer = new StringTokenizer(attribute, ".");
            String token = null;
            Object value = RecursiveAttributeFormatter.getDataObject((DomainObject)item);
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if ((value = value.get(token)) != null) continue;
                return this.getDefaultString();
            }
            if (token == null || value == null) {
                return this.getDefaultString();
            }
            return value.toString();
        }
    }

    private static class SimpleAttributeFormatter
    extends DefaultAttributeFormatter {
        public SimpleAttributeFormatter() {
        }

        public SimpleAttributeFormatter(String def) {
            super(def);
        }

        public String format(ContentItem item, String attribute, PageState state) {
            Object value = SimpleAttributeFormatter.get((DomainObject)item, (String)attribute);
            if (value == null) {
                return this.getDefaultString();
            }
            return value.toString();
        }
    }

    private static abstract class DefaultAttributeFormatter
    extends DomainService
    implements AttributeFormatter {
        private String m_default;

        public DefaultAttributeFormatter() {
            this("<i>unknown</i>");
        }

        public DefaultAttributeFormatter(String def) {
            this.m_default = def;
        }

        public String getDefaultString() {
            return this.m_default;
        }
    }

    private static class ItemModelBuilder
    extends LockableImpl
    implements PropertySheetModelBuilder {
        private ItemModelBuilder() {
        }

        public PropertySheetModel makeModel(PropertySheet sheet, PageState state) {
            ItemPropertySheet s = (ItemPropertySheet)sheet;
            return new ItemPropertiesModel((ContentItem)s.getItemSelectionModel().getSelectedObject(state), s.properties(), state);
        }
    }

    private static class ItemPropertiesModel
    implements PropertySheetModel {
        private ContentItem m_item;
        private PageState m_state;
        private Iterator m_props;
        private Property m_current;
        private static final String ERROR = "No current property. Make sure that nextRow() was called at least once.";

        public ItemPropertiesModel(ContentItem item, Iterator props, PageState state) {
            this.m_item = item;
            this.m_props = props;
            this.m_state = state;
            this.m_current = null;
        }

        public boolean nextRow() {
            if (!this.m_props.hasNext()) {
                return false;
            }
            this.m_current = (Property)this.m_props.next();
            return true;
        }

        public String getLabel() {
            return this.getGlobalizedLabel().getKey();
        }

        public GlobalizedMessage getGlobalizedLabel() {
            if (this.m_current == null) {
                throw new IllegalStateException(ERROR);
            }
            return this.m_current.getGlobalizedLabel();
        }

        public String getValue() {
            if (this.m_current == null) {
                throw new IllegalStateException(ERROR);
            }
            return this.m_current.getFormatter().format(this.m_item, this.m_current.getAttribute(), this.m_state);
        }
    }

    private static class Property {
        private GlobalizedMessage m_label;
        private String m_attr;
        private AttributeFormatter m_formatter;

        public Property(GlobalizedMessage l, String a, AttributeFormatter f) {
            this.m_label = l;
            this.m_attr = a;
            this.m_formatter = f;
        }

        public String getLabel() {
            return this.m_label.getKey();
        }

        public GlobalizedMessage getGlobalizedLabel() {
            return this.m_label;
        }

        public String getAttribute() {
            return this.m_attr;
        }

        public AttributeFormatter getFormatter() {
            return this.m_formatter;
        }
    }

    public static interface AttributeFormatter {
        public String format(ContentItem var1, String var2, PageState var3);
    }
}

