/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.xml.Element;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class DomainObjectRenderer
extends SimpleContainer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/DomainObjectRenderer.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private DomainObjectSelectionModel m_model;
    private int m_depth;
    public static final String CMS_XML_NS = "http://www.arsdigita.com/cms/1.0";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$DomainObjectRenderer == null ? (class$com$arsdigita$cms$ui$DomainObjectRenderer = DomainObjectRenderer.class$("com.arsdigita.cms.ui.DomainObjectRenderer")) : class$com$arsdigita$cms$ui$DomainObjectRenderer));
    static /* synthetic */ Class class$com$arsdigita$cms$ui$DomainObjectRenderer;

    public DomainObjectRenderer(DomainObjectSelectionModel model) {
        this(model, 2);
    }

    public DomainObjectRenderer(DomainObjectSelectionModel model, int depth) {
        this.m_model = model;
        this.m_depth = depth;
    }

    public int getDepth() {
        return this.m_depth;
    }

    public void setDepth(int depth) {
        Assert.assertNotLocked((Lockable)this);
        this.m_depth = depth;
    }

    public DomainObjectSelectionModel getSelectionModel() {
        return this.m_model;
    }

    public void setSelectionModel(DomainObjectSelectionModel model) {
        Assert.assertNotLocked((Lockable)this);
        this.m_model = model;
    }

    public DomainObject getDomainObject(PageState state) {
        return this.m_model.getSelectedObject(state);
    }

    public void setDomainObject(PageState state, DomainObject obj) {
        this.m_model.setSelectedObject(state, obj);
    }

    protected Element generateXML(DomainObject obj, String elementName, String elementNameSpace, int depthRemaining, Set visited) {
        Element node = new Element(elementName, elementNameSpace);
        OID oid = obj.getOID();
        node.addAttribute("oid", oid.toString());
        if (depthRemaining < 1) {
            return node;
        }
        if (visited.contains(oid)) {
            return node;
        }
        visited.add(oid);
        ObjectType type = oid.getObjectType();
        Iterator i = type.getProperties();
        while (i.hasNext()) {
            Property prop = (Property)i.next();
            String propName = prop.getName();
            Object propValue = null;
            try {
                propValue = DomainServiceInterfaceExposer.get((DomainObject)obj, (String)propName);
            }
            catch (Exception e) {
                s_log.error((Object)"Ignoring some random exception", (Throwable)e);
            }
            if (propValue == null) continue;
            if (prop.isRole()) {
                int newDepth = depthRemaining - 1;
                if (propValue instanceof DataObject) {
                    node.addContent(this.generateXML(DomainObjectFactory.newInstance((DataObject)((DataObject)propValue)), propName, "", newDepth, visited));
                    continue;
                }
                if (!(propValue instanceof DataAssociation)) continue;
                DataAssociationCursor daCursor = ((DataAssociation)propValue).getDataAssociationCursor();
                while (daCursor.next()) {
                    node.addContent(this.generateXML(DomainObjectFactory.newInstance((DataObject)daCursor.getDataObject()), propName, "", newDepth, visited));
                }
                continue;
            }
            Element child = new Element(propName);
            child.setText(propValue.toString());
            node.addContent(child);
        }
        return node;
    }

    public Element generateXMLElement(PageState state) {
        DomainObject obj = this.getDomainObject(state);
        if (obj != null) {
            return this.generateXML(obj, "cms:domainObjectRenderer", CMS_XML_NS, this.getDepth(), new HashSet());
        }
        return null;
    }

    public Element generateXMLElement(DomainObject obj) {
        return this.generateXML(obj, "cms:domainObjectRenderer", CMS_XML_NS, this.getDepth(), new HashSet());
    }

    public void generateXML(PageState state, Element parent) {
        Element e = this.generateXMLElement(state);
        if (e != null) {
            parent.addContent(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

