/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.authoring.NewItemForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.Web;
import java.math.BigDecimal;

public class ContentSectionContainer
extends CMSContainer {
    public static final String versionID = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentSectionContainer.java#12 $";
    private ContentSectionTable m_table;
    private FormContainer m_formContainer;
    private SingleSelectionModel m_typeSel;
    private SingleSelectionModel m_sectionSel;

    public ContentSectionContainer(SingleSelectionModel typeSel, SingleSelectionModel sectionSel) {
        this.m_typeSel = typeSel;
        this.m_sectionSel = sectionSel;
        this.m_formContainer = new FormContainer();
        this.add((Component)this.m_formContainer);
        this.m_table = new ContentSectionTable();
        this.add((Component)this.m_table);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_formContainer, false);
    }

    static /* synthetic */ SingleSelectionModel access$400(ContentSectionContainer x0) {
        return x0.m_sectionSel;
    }

    static /* synthetic */ SingleSelectionModel access$500(ContentSectionContainer x0) {
        return x0.m_typeSel;
    }

    public static class AdminURLTableCellRenderer
    extends URLTableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentSection section = (ContentSection)((Object)value);
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess(state.getRequest(), "admin_pages")) {
                return new Link(section.getName(), this.generateURL(section.getPath() + "/"));
            }
            return new Label(section.getName(), false);
        }

        protected String generateURL(String prefix) {
            return prefix + "admin/index.jsp";
        }
    }

    public static class URLTableCellRenderer
    implements TableCellRenderer {
        private static final String URL_STUB = "/";

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentSection section = (ContentSection)((Object)value);
            String baseUrl = this.getBaseURL();
            String name = section.getName();
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess(state.getRequest(), "public_pages")) {
                return new Link(baseUrl + name + URL_STUB, baseUrl + this.generateURL(name));
            }
            return new Label(baseUrl + name + URL_STUB, false);
        }

        protected String trimSlashes(String string) {
            while (string != null && string.length() > 0 && string.charAt(0) == '/') {
                string = string.substring(1);
            }
            return string;
        }

        protected String generateURL(String prefix) {
            return this.trimSlashes(prefix) + URL_STUB;
        }

        protected String getBaseURL() {
            StringBuffer buf = new StringBuffer(15);
            buf.append(Utilities.getWebappContext()).append(SiteNode.getRootSiteNode().getURL());
            String url = buf.toString();
            if (url.endsWith(URL_STUB)) {
                return url;
            }
            return url + URL_STUB;
        }
    }

    private class ContentSectionTable
    extends Table {
        private static final String COLUMN_SECTION = "Section";
        private static final String COLUMN_LOCATION = "Public Site";
        private static final String COLUMN_ACTION = "Action";

        private ContentSectionTable() {
            Label emptyView = new Label("There are currently no content sections installed.");
            emptyView.setFontWeight("i");
            this.setEmptyView((Component)emptyView);
            this.setClassAttr("dataTable");
            TableColumnModel columnModel = this.getColumnModel();
            TableColumn contentSectionColumn = new TableColumn(0, (Object)COLUMN_SECTION);
            TableColumn locationColumn = new TableColumn(1, (Object)COLUMN_LOCATION);
            TableColumn actionColumn = new TableColumn(2, (Object)COLUMN_ACTION);
            contentSectionColumn.setCellRenderer((TableCellRenderer)new AdminURLTableCellRenderer());
            locationColumn.setCellRenderer((TableCellRenderer)new URLTableCellRenderer());
            actionColumn.setCellRenderer((TableCellRenderer)new ActionTableCellRenderer());
            columnModel.add(contentSectionColumn);
            columnModel.add(locationColumn);
            columnModel.add(actionColumn);
            this.setModelBuilder(new ContentSectionTableModelBuilder());
        }

        private class ActionTableCellRenderer
        implements TableCellRenderer {
            private ActionTableCellRenderer() {
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                SecurityManager sm;
                ContentSection section = (ContentSection)((Object)value);
                Folder folder = null;
                User user = Web.getContext().getUser();
                if (user != null) {
                    folder = Folder.getUserHomeFolder(user, section);
                }
                if (folder == null) {
                    folder = section.getRootFolder();
                }
                if (!(sm = new SecurityManager(section)).canAccess(state.getRequest(), "new_item", (ContentItem)folder)) {
                    return new Label("&nbsp;", false);
                }
                ContentSectionContainer.this.m_formContainer.getNewItemForm().setSectionId(state, section.getID());
                return ContentSectionContainer.this.m_formContainer.getNewItemForm();
            }
        }

        private class ContentSectionTableModel
        implements TableModel {
            private ContentSectionTable m_table;
            private TableColumnModel m_columnModel;
            private PageState m_state;
            private ContentSectionCollection m_contentSections;
            private ContentSection m_section;

            private ContentSectionTableModel(ContentSectionTable table, PageState state) {
                this.m_table = table;
                this.m_columnModel = table.getColumnModel();
                this.m_state = state;
                this.m_contentSections = this.getContentSectionCollection();
                PermissionService.filterObjects((DomainCollection)this.m_contentSections, (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)Kernel.getContext().getParty().getOID());
            }

            protected ContentSectionCollection getContentSectionCollection() {
                ContentSectionCollection sections = ContentSection.getAllSections();
                sections.addOrder("lower(label)");
                return sections;
            }

            public int getColumnCount() {
                return this.m_columnModel.size();
            }

            public boolean nextRow() {
                if (this.m_contentSections.next()) {
                    this.m_section = this.m_contentSections.getContentSection();
                    return true;
                }
                return false;
            }

            public Object getElementAt(int columnIndex) {
                if (this.m_columnModel == null || this.m_section == null) {
                    return null;
                }
                TableColumn tc = this.m_columnModel.get(columnIndex);
                String columnName = (String)tc.getHeaderValue();
                ContentSection result = this.m_section;
                if (columnName.equals(ContentSectionTable.COLUMN_SECTION) || columnName.equals(ContentSectionTable.COLUMN_LOCATION) || columnName.equals(ContentSectionTable.COLUMN_ACTION)) {
                    result = this.m_section;
                }
                return result;
            }

            public Object getKeyAt(int columnIndex) {
                return this.m_section.getID();
            }

            protected Table getTable() {
                return this.m_table;
            }

            protected PageState getPageState() {
                return this.m_state;
            }
        }

        private class ContentSectionTableModelBuilder
        extends LockableImpl
        implements TableModelBuilder {
            private ContentSectionTableModelBuilder() {
            }

            public TableModel makeModel(Table table, PageState state) {
                table.getRowSelectionModel().clearSelection(state);
                return new ContentSectionTableModel((ContentSectionTable)table, state);
            }
        }
    }

    private static class StaticNewItemForm
    extends NewItemForm {
        private Hidden m_sectionIDParamWidget;

        public StaticNewItemForm(BigDecimalParameter sectionParam) {
            super("StaticNewItemForm");
            this.m_sectionIDParamWidget = new Hidden((ParameterModel)sectionParam);
            this.add((Component)this.m_sectionIDParamWidget);
            this.setProcessInvisible(true);
        }

        public void setSectionId(PageState state, BigDecimal id) {
            Assert.assertNotNull((Object)id);
            this.m_sectionIDParamWidget.setValue(state, (Object)id);
        }

        public ContentSection getContentSection(PageState state) {
            ContentSection section;
            BigDecimal id = this.getContentSectionID(state);
            Assert.assertNotNull((Object)id);
            try {
                section = new ContentSection(id);
            }
            catch (DataObjectNotFoundException ex) {
                section = null;
            }
            return section;
        }

        private BigDecimal getContentSectionID(PageState state) {
            return (BigDecimal)this.m_sectionIDParamWidget.getValue(state);
        }

        static /* synthetic */ BigDecimal access$200(StaticNewItemForm x0, PageState x1) {
            return x0.getContentSectionID(x1);
        }
    }

    private class FormContainer
    extends CMSContainer {
        private StaticNewItemForm m_form;
        private BigDecimalParameter m_sectionIdParam = new BigDecimalParameter("sectionId");

        private FormContainer() {
            this.m_form = new StaticNewItemForm(this.m_sectionIdParam);
            this.m_form.addSubmissionListener(new FormSubmissionListener(){

                public void submitted(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    StaticNewItemForm form = (StaticNewItemForm)((Object)event.getSource());
                    ContentSection section = form.getContentSection(state);
                    SecurityManager sm = new SecurityManager(section);
                    Folder folder = null;
                    User user = Web.getContext().getUser();
                    if (user != null) {
                        folder = Folder.getUserHomeFolder(user, section);
                    }
                    if (folder == null) {
                        folder = section.getRootFolder();
                    }
                    if (!sm.canAccess(state.getRequest(), "new_item", (ContentItem)folder)) {
                        throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.insufficient_privileges").localize());
                    }
                }
            });
            this.m_form.addProcessListener(new FormProcessListener(this){
                private final /* synthetic */ FormContainer this$1;
                {
                    this.this$1 = this$1;
                }

                public void process(FormSectionEvent e) throws FormProcessException {
                    PageState state;
                    StaticNewItemForm form = (StaticNewItemForm)((Object)e.getSource());
                    BigDecimal typeId = form.getTypeID(state = e.getPageState());
                    if (typeId != null) {
                        BigDecimal sectionId = StaticNewItemForm.access$200(form, state);
                        ContentSectionContainer.access$400(FormContainer.access$300(this.this$1)).setSelectedKey(state, (Object)sectionId);
                        ContentSectionContainer.access$500(FormContainer.access$300(this.this$1)).setSelectedKey(state, (Object)typeId);
                    }
                }
            });
            this.add((Component)this.m_form);
        }

        public void register(Page p) {
            super.register(p);
            p.addComponentStateParam((Component)this, (ParameterModel)this.m_sectionIdParam);
        }

        public StaticNewItemForm getNewItemForm() {
            return this.m_form;
        }

        static /* synthetic */ ContentSectionContainer access$300(FormContainer x0) {
            return x0.ContentSectionContainer.this;
        }
    }
}

