/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.toolbox.ui.QueryEvent;
import com.arsdigita.toolbox.ui.QueryListener;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class ContentPageTable
extends DataTable {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentPageTable.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ContentType m_type = null;
    private String m_queryName;
    private String m_context;
    public static final String TYPE_LABEL = "typeLabel";

    public ContentPageTable(String queryName, String context) {
        super((DataQueryBuilder)new QueryModelBuilder(queryName));
        this.m_context = context;
        this.m_queryName = queryName;
        this.setBorder("0");
        this.setCellSpacing("5");
        this.addColumn("Name", "name", true, new URLCellRenderer());
        this.addColumn("Title", "title", true);
        this.addColumn("Type", TYPE_LABEL, true);
        Label empty = new Label(GlobalizationUtil.globalize("cms.ui.there_are_no_items"));
        empty.setFontWeight("i");
        this.setEmptyView((Component)empty);
        this.addQueryListener(new SectionQueryListener());
    }

    public void register(Page p) {
        super.register(p);
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState s = e.getPageState();
                if (!ContentPageTable.this.getOrderSelectionModel().isSelected(s)) {
                    ContentPageTable.this.setOrder(s, ContentPageTable.this.getColumnModel().get(0).getHeaderKey().toString());
                }
            }
        });
    }

    public String getContext() {
        return this.m_context;
    }

    public void setContext(String context) {
        Assert.assertNotLocked((Lockable)this);
        this.m_context = context;
    }

    public void setContentType(ContentType c) {
        Assert.assertNotLocked((Lockable)this);
        this.m_type = c;
    }

    public ContentType getContentType() {
        return this.m_type;
    }

    public String getDataQueryName() {
        return this.m_queryName;
    }

    private static class URLCellRenderer
    implements TableCellRenderer {
        private URLCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ContentSection section = CMS.getContext().getContentSection();
            ContentPageTable t = (ContentPageTable)table;
            String name = (String)value;
            BigDecimal id = (BigDecimal)key;
            if (section == null) {
                return new Link(name, name);
            }
            ItemResolver resolver = section.getItemResolver();
            return new Link(name, resolver.generateItemURL(state, id, name, section, t.getContext()));
        }
    }

    private static class SectionQueryListener
    implements QueryListener {
        private SectionQueryListener() {
        }

        public void queryPending(QueryEvent e) {
            Filter f;
            ContentPageTable t = (ContentPageTable)((Object)e.getSource());
            PageState s = e.getPageState();
            DataQuery data = e.getDataQuery();
            ContentType type = t.getContentType();
            ContentSection sec = CMS.getContext().getContentSection();
            if (sec == null) {
                throw new IllegalStateException((String)GlobalizationUtil.globalize("cms.ui.no_content_section_for_page").localize());
            }
            if (type != null) {
                f = data.addFilter("typeId = :typeId and parentId = :parentId");
                f.set("typeId", (Object)type.getID());
            } else {
                f = data.addFilter("parentId = :parentId");
            }
            f.set("parentId", (Object)sec.getRootFolder().getID());
            f = data.addFilter("version = :version");
            f.set("version", (Object)t.getContext());
        }
    }

    private static class QueryModelBuilder
    extends LockableImpl
    implements DataQueryBuilder {
        private String m_queryName;

        public QueryModelBuilder(String queryName) {
            this.m_queryName = queryName;
        }

        public DataQuery makeDataQuery(DataTable d, PageState s) {
            Session session = SessionManager.getSession();
            DataQuery data = session.retrieveQuery(this.m_queryName);
            return data;
        }

        public String getKeyColumn() {
            return "itemId";
        }
    }
}

