/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.publishToFile.DestinationStub;
import com.arsdigita.cms.publishToFile.PublishToFile;
import com.arsdigita.cms.publishToFile.PublishToFileListener;
import com.arsdigita.cms.publishToFile.PublishedFile;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.runtime.CCM;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class Initializer
implements com.arsdigita.initializer.Initializer {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$publishToFile$Initializer == null ? (class$com$arsdigita$cms$publishToFile$Initializer = Initializer.class$("com.arsdigita.cms.publishToFile.Initializer")) : class$com$arsdigita$cms$publishToFile$Initializer));
    private static final String PUBLISH_DESTINATIONS = "destination";
    private static final String PUBLISH_TO_FILE_LISTENER = "publishListener";
    private static final String QUEUE_POLL_STARTUP_DELAY = "startupDelay";
    private static final String QUEUE_POLL_DELAY = "pollDelay";
    private static final String RETRY_DELAY = "retryDelay";
    private static final String REQUEST_TIMEOUT = "requestTimeout";
    private static final String BLOCK_SIZE = "blockSize";
    private static final String BLOCK_SELECT_METHOD = "blockSelectMethod";
    private static final String MAXIMUM_FAIL_COUNT = "maximumFailCount";
    private Configuration m_conf = new Configuration();
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$Initializer;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public Initializer() throws InitializationException {
        this.m_conf.initParameter(PUBLISH_DESTINATIONS, "List of publish destinations for content typesEach element is a four-element list in the format '{ \"content type\", \"root directory\", \"shared storage\", \"url stub\" }'. Content type is the object type of the content type.Root directory must be a path to a writable directory, relativeto the webapp root. Shared storage must be true if the root directory is shared NFS storage, false otherwise. URL stub is must be the path component of the URL from which the live server will serve from this directory.", class$java$util$List == null ? (class$java$util$List = Initializer.class$("java.util.List")) : class$java$util$List);
        this.m_conf.initParameter(PUBLISH_TO_FILE_LISTENER, "Class which implements PublishToFileListener used to perform additional actions when publishing or unpublishing to the file system.", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String);
        this.m_conf.initParameter(QUEUE_POLL_STARTUP_DELAY, "Time (in seconds) after system startup to wait before starting to monitor publishToFile queue.  A value < 0 disables processing of the queue on this server.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(30));
        this.m_conf.initParameter(QUEUE_POLL_DELAY, "Time (in seconds) between checking if there are entries in the publishToFile queue. A value <= 0 disables processing the queue on this server.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(1));
        this.m_conf.initParameter(RETRY_DELAY, "Time to wait (seconds) before retrying to process a failed entry.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(120));
        this.m_conf.initParameter(REQUEST_TIMEOUT, "Time to wait (seconds) before aborting item request.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(60));
        this.m_conf.initParameter(BLOCK_SIZE, "number of queue entries to process in one txn.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(20));
        this.m_conf.initParameter(BLOCK_SELECT_METHOD, "Method used to select entries for processing.  'QueuedOrder'-in  queued order. 'GroupByParent'-group entries according to parent when selecting items (allows optimizations if a listener task required for all elements in a folder can be done only once for the folder).", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, (Object)"QueuedOrder");
        this.m_conf.initParameter(MAXIMUM_FAIL_COUNT, "Maximum Fail Count for actions in Queue Manager. If Fail Count in Database is more than Specified Limit, Queue Manager will ignore the action. The Default Value -1 will ignore this parameter.", class$java$lang$Integer == null ? (class$java$lang$Integer = Initializer.class$("java.lang.Integer")) : class$java$lang$Integer, (Object)new Integer(-1));
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    public void startup() {
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        this.setupPublishToFileSystem();
        QueueManager.requeueMissingFiles();
        txn.commitTxn();
    }

    public void shutdown() {
        QueueManager.stopWatchingQueue();
    }

    private void setupPublishToFileSystem() throws InitializationException {
        DomainObjectInstantiator inst = new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dobj) {
                return new PublishedFile(dobj);
            }
        };
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.publishToFile.PublishedFile", (DomainObjectInstantiator)inst);
        Initializer.processDestination((List)this.m_conf.getParameter(PUBLISH_DESTINATIONS));
        PublishToFile.setRequestTimeout(this.getInteger(REQUEST_TIMEOUT));
        QueueManager.setRetryDelay(this.getInteger(RETRY_DELAY));
        QueueManager.setBlockSize(this.getInteger(BLOCK_SIZE));
        QueueManager.setBlockSelectMethod(this.getString(BLOCK_SELECT_METHOD));
        QueueManager.setMaximumFailCount(this.getInteger(MAXIMUM_FAIL_COUNT));
        String listenerName = this.getString(PUBLISH_TO_FILE_LISTENER);
        if (listenerName != null) {
            PublishToFileListener listener = null;
            Class<?> listenerClass = null;
            try {
                listenerClass = Class.forName(listenerName);
            }
            catch (ClassNotFoundException ex) {
                Initializer.invalidParam(PUBLISH_TO_FILE_LISTENER, "could not find listener class " + listenerClass);
            }
            try {
                listener = (PublishToFileListener)listenerClass.newInstance();
            }
            catch (InstantiationException ex) {
                Initializer.invalidParam(PUBLISH_TO_FILE_LISTENER, "could not find instantiate listener class " + listenerClass + " (" + ex.getMessage() + ")");
            }
            catch (IllegalAccessException ex) {
                Initializer.invalidParam(PUBLISH_TO_FILE_LISTENER, "could not find instantiate listener class " + listenerClass + " (" + ex.getMessage() + ")");
            }
            QueueManager.setListener(listener);
        }
        int startupDelay = this.getInteger(QUEUE_POLL_STARTUP_DELAY);
        int pollDelay = this.getInteger(QUEUE_POLL_DELAY);
        QueueManager.startWatchingQueue(startupDelay, pollDelay);
    }

    private static void processDestination(List dest) throws InitializationException {
        if (dest == null) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "publish destinations must not be null");
        }
        if (dest.size() < 1) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "publish destinations must contain at least one entry");
        }
        Iterator entries = dest.iterator();
        while (entries.hasNext()) {
            Initializer.processDestinationEntry((List)entries.next());
        }
    }

    private static void processDestinationEntry(List entry) throws InitializationException {
        File conf;
        DestinationStub dest;
        File file;
        ObjectType type;
        if (entry.size() != 4) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "publish destinations entry must contain four elements: '{ \n  \"content type\",\n  \"root directory\", \n  \"is shared\", \n  \"url stub\" \n};\n");
        }
        String contentType = (String)entry.get(0);
        String destRoot = (String)entry.get(1);
        Boolean sharedRoot = (Boolean)entry.get(2);
        String destURL = (String)entry.get(3);
        if (contentType == null || contentType.trim().length() == 0) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination content type must not be null");
        }
        if ((type = MetadataRoot.getMetadataRoot().getObjectType(contentType)) == null) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination content type cannot be found");
        }
        if (destRoot == null || destRoot.trim().length() == 0) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination root must not be null");
        }
        if (destRoot.endsWith("/")) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination root '" + destRoot + "' must not end with a '/'");
        }
        destRoot = new File(System.getProperty("ccm.home"), destRoot).getPath();
        if (sharedRoot == null) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination shared flag must not be null");
        }
        if (destURL == null || "".equals(destURL.trim())) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination URL must not be null");
        }
        if (!destURL.startsWith("/")) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination URL '" + destURL + "' must start with a '/'");
        }
        if (destURL.endsWith("/")) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, "the destination URL '" + destURL + "' must not end with a '/'");
        }
        if (!(file = (dest = new DestinationStub(destRoot, sharedRoot, destURL)).getFile()).exists()) {
            file.mkdirs();
        }
        boolean writable = false;
        try {
            writable = file.canWrite() && file.isDirectory();
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        if (!(writable || (conf = CCM.getConfigDirectory()).isDirectory() && conf.canWrite())) {
            Initializer.invalidParam(PUBLISH_DESTINATIONS, " the document root '" + file + "' must be a writable directory");
        }
        if ("com.arsdigita.cms.Template".equals(contentType) || !ContentSection.getConfig().getDisableItemPfs()) {
            PublishToFile.addDestination(contentType, dest);
        }
    }

    private Integer getInteger(String paramName) {
        return (Integer)this.m_conf.getParameter(paramName);
    }

    private String getString(String paramName) {
        return (String)this.m_conf.getParameter(paramName);
    }

    private static void invalidParam(String param, String msg) throws InitializationException {
        throw new InitializationException("publishToFile: parameter " + param + ": " + msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

