/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.UserTask;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class NotifyLifecycleListener
implements LifecycleListener {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$lifecycle$NotifyLifecycleListener == null ? (class$com$arsdigita$cms$lifecycle$NotifyLifecycleListener = NotifyLifecycleListener.class$("com.arsdigita.cms.lifecycle.NotifyLifecycleListener")) : class$com$arsdigita$cms$lifecycle$NotifyLifecycleListener));
    private static final String ALERT_RECIPIENT_ROLE = "Alert Recipient";
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$NotifyLifecycleListener;

    public void begin(LifecycleEvent event) {
        if (event.getEventType() != 0) {
            s_log.error((Object)"NotifyLifecycleListener called for  LifecycleEvent.LIFECYCLE event, but this class only handles LifecycleEvent.PHASE events!");
            return;
        }
        ContentItem item = this.getContentItem(event.getOID());
        ContentSection section = item.getContentSection();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("item = " + (item == null ? "null" : item.toString())));
            s_log.debug((Object)("section = " + (section == null ? "null" : section.toString())));
        }
        Assert.assertNotNull((Object)item, (String)"content item");
        Assert.assertNotNull((Object)((Object)section), (String)"content section");
        UserCollection spamVictims = this.getRecipients(item);
        Notification notif = null;
        User user = null;
        Message message = this.createMessage(item, event);
        if (spamVictims != null && message != null) {
            while (spamVictims.next()) {
                user = (User)spamVictims.getDomainObject();
                notif = new Notification((Party)user, message);
                if (!s_log.isDebugEnabled()) continue;
                s_log.debug((Object)("spamming user " + user.getPrimaryEmail()));
            }
        } else {
            s_log.debug((Object)"NO users need to be notified");
        }
    }

    public void end(LifecycleEvent event) {
    }

    private ContentItem getContentItem(OID oid) {
        s_log.debug((Object)"getting content item");
        ContentItem item = null;
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace();
            throw new UncheckedWrapperException((Throwable)e);
        }
        return item;
    }

    protected UserCollection getRecipients(ContentItem item) {
        ContentSection section = item.getContentSection();
        Group alertsGroup = section.getStaffGroup();
        Role alertRole = alertsGroup.getRole(ALERT_RECIPIENT_ROLE);
        UserCollection usersToAlert = null;
        if (alertRole != null) {
            usersToAlert = alertRole.getMemberUsers();
            Filter pFilter = PermissionService.getObjectFilterQuery((FilterFactory)usersToAlert.getFilterFactory(), (String)"id", (PrivilegeDescriptor)PrivilegeDescriptor.get((String)"cms_edit_item"), (OID)item.getWorkingVersion().getParent().getOID());
            usersToAlert.addFilter(pFilter);
        }
        return usersToAlert;
    }

    protected Message createMessage(ContentItem item, LifecycleEvent lc) {
        Assert.assertNotNull((Object)item, (String)"content item");
        Message message = null;
        Party sender = UserTask.getAlertsSender();
        if (sender == null) {
            s_log.error((Object)"Failed to get 'from' party from UserTask ");
        } else {
            ContentSection section = item.getContentSection();
            DateFormat df = DateFormat.getDateInstance(1);
            String name = null;
            name = item instanceof ContentPage ? ((ContentPage)item).getTitle() : item.getName();
            String subject = "Content Item " + name + " is about to expire";
            String publicURL = URL.there((String)(section.getSiteNode().getURL(DispatcherHelper.getWebappContext()) + item.getPath()), null).getURL();
            String adminURL = URL.there((String)ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB), null).getURL();
            StringBuffer body = new StringBuffer(300);
            body.append("Content Item ");
            body.append(name);
            body.append(" at URL \n");
            body.append(publicURL);
            body.append(" is going to expire at ");
            body.append(df.format(lc.getEndDate()));
            body.append("\nAccess item administration here: ");
            body.append(adminURL);
            message = new Message(sender, subject, body.toString());
        }
        return message;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

