/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import java.util.Date;

public class LifecycleEvent {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/LifecycleEvent.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_eventType;
    private Date m_startDateTime;
    private Date m_endDateTime;
    private OID m_oid;
    public static final int PHASE = 0;
    public static final int LIFECYCLE = 1;

    protected LifecycleEvent(int eventType, Date start, Date end, String objectType, BigDecimal id) {
        this(eventType, start, end, new OID(objectType, (Object)id));
    }

    protected LifecycleEvent(int eventType, Date start, Date end, OID oid) {
        this.m_eventType = eventType;
        this.m_startDateTime = start;
        this.m_endDateTime = end;
        this.m_oid = oid;
    }

    public int getEventType() {
        return this.m_eventType;
    }

    public Date getStartDate() {
        return this.m_startDateTime;
    }

    public Date getEndDate() {
        return this.m_endDateTime;
    }

    public OID getOID() {
        return this.m_oid;
    }

    public String toString() {
        String type = this.m_eventType == 0 ? "Phase" : "Lifecycle";
        String endDate = this.m_endDateTime == null ? "never" : this.m_endDateTime.toString();
        return "LifecycleEvent (" + type + ")- startDateTime:" + this.m_startDateTime.toString() + " endDateTime:" + endDate;
    }
}

