/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.installer.xml.ContentItemHelper;
import com.arsdigita.cms.installer.xml.ContentPageHelper;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XMLContentItemHandler
extends DefaultHandler {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$xml$XMLContentItemHandler == null ? (class$com$arsdigita$cms$installer$xml$XMLContentItemHandler = XMLContentItemHandler.class$("com.arsdigita.cms.installer.xml.XMLContentItemHandler")) : class$com$arsdigita$cms$installer$xml$XMLContentItemHandler));
    public static final String CONTENT_ITEMS = "ccm:content-items";
    public static final String CONTENT_ITEM = "ccm:content-item";
    public static final String ASSOCIATED_ITEM = "ccm:associated-item";
    public static final String CONTENT_TYPE = "ccm:content-type";
    public static final String ITEM_PROPERTIES = "ccm:item-properties";
    public static final String ITEM_PROPERTY = "ccm:item-property";
    public static final String FOLDER = "ccm:folder";
    public static final String BODY_TEXT = "ccm:body-text";
    private xmlContentItem currItem;
    private Folder m_folder;
    private FolderTree currFolderTree;
    private Stack associated_items;
    boolean isAssociated = false;
    private ContentSection m_section;
    private String m_body = "foo!";
    static /* synthetic */ Class class$com$arsdigita$cms$installer$xml$XMLContentItemHandler;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    public XMLContentItemHandler(ContentSection section) {
        s_log.debug((Object)(class$com$arsdigita$cms$installer$xml$XMLContentItemHandler == null ? (class$com$arsdigita$cms$installer$xml$XMLContentItemHandler = XMLContentItemHandler.class$("com.arsdigita.cms.installer.xml.XMLContentItemHandler")) : class$com$arsdigita$cms$installer$xml$XMLContentItemHandler).getName());
        this.m_section = section;
        this.currFolderTree = new FolderTree(null);
        this.associated_items = new Stack();
    }

    public void startElement(String uri, String name, String qName, Attributes atts) {
        if (!qName.equals(CONTENT_ITEMS)) {
            if (qName.equals(FOLDER)) {
                FolderHelper new_folderHelper = new FolderHelper(this.m_section);
                new_folderHelper.setCloneCount(Integer.parseInt(atts.getValue("clone")));
                new_folderHelper.setName(this.validateTitle(atts.getValue("label")));
                new_folderHelper.setDepth(Integer.parseInt(atts.getValue("depth")));
                FolderTree newFolderTree = new FolderTree(new_folderHelper);
                newFolderTree.setParentTree(this.currFolderTree);
                this.currFolderTree.addSubTree(newFolderTree);
                this.currFolderTree = newFolderTree;
                this.m_folder = (Folder)this.currFolderTree.getFolderHelper().createContentItem(true);
            } else if (qName.equals(CONTENT_ITEM)) {
                xmlContentItem newItem = new xmlContentItem();
                newItem.setHelperClass(atts.getValue("helperClass"));
                newItem.setCloneCount(atts.getValue("clone"));
                if (this.m_folder != null) {
                    newItem.getHelperClass().setParent(this.m_folder);
                }
                if (this.currItem != null) {
                    if (this.isAssociated) {
                        this.associated_items.push(this.currItem);
                    }
                    this.isAssociated = true;
                    newItem.setParentItem(this.currItem);
                    String associationName = atts.getValue("association-name");
                    Assert.exists((Object)associationName, (Class)(class$java$lang$String == null ? (class$java$lang$String = XMLContentItemHandler.class$("java.lang.String")) : class$java$lang$String));
                    this.currItem.setAssociation(associationName, newItem);
                } else {
                    this.currFolderTree.addContentItem(newItem);
                }
                this.currItem = newItem;
            } else if (qName.equals(CONTENT_TYPE)) {
                String objectType = atts.getValue("objectType");
                Assert.exists((Object)objectType, (Class)(class$java$lang$String == null ? (class$java$lang$String = XMLContentItemHandler.class$("java.lang.String")) : class$java$lang$String));
                this.currItem.setContentType(objectType);
            } else if (qName.equals(ITEM_PROPERTIES)) {
                String itemName = atts.getValue("title");
                Assert.exists((Object)itemName, (Class)(class$java$lang$String == null ? (class$java$lang$String = XMLContentItemHandler.class$("java.lang.String")) : class$java$lang$String));
                this.validateTitle(itemName);
                this.currItem.setName(itemName);
                String l_lang = atts.getValue("language");
                if (l_lang != null && !l_lang.equals("")) {
                    this.currItem.getHelperClass().setLanguage(l_lang);
                }
                this.currItem.create(false);
            } else if (qName.equals(BODY_TEXT)) {
                s_log.warn((Object)"Begin Body text");
            } else if (qName.equals(ITEM_PROPERTY)) {
                s_log.debug((Object)"setting property");
                this.currItem.getHelperClass().set(atts.getValue("method"), atts.getValue("argClass"), atts.getValue("argValue"));
            } else {
                s_log.debug((Object)("Unknown tag: " + name));
            }
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.m_body = new String(ch, start, length);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals(BODY_TEXT)) {
            s_log.warn((Object)"Setting body text");
            this.currItem.getHelperClass().setBodyText(this.m_body);
        } else if (!qName.equals(ITEM_PROPERTIES) && !qName.equals(CONTENT_TYPE)) {
            if (qName.equals(CONTENT_ITEM)) {
                this.currItem.save();
                if (this.isAssociated && !this.associated_items.isEmpty()) {
                    this.currItem = (xmlContentItem)this.associated_items.pop();
                } else if (this.isAssociated && this.associated_items.isEmpty()) {
                    this.isAssociated = false;
                }
                if (!this.isAssociated) {
                    this.currItem = this.currItem.getParentItem();
                }
            } else if (qName.equals(FOLDER)) {
                s_log.debug((Object)("Reached folder end item with folderHelper: " + this.currFolderTree));
                this.currFolderTree.getFolderHelper().save();
                this.currFolderTree = this.currFolderTree.getParentTree();
                this.m_folder = !this.currFolderTree.isRoot() ? (Folder)this.currFolderTree.getFolderHelper().create(true) : null;
                s_log.debug((Object)"Done Folder endElement");
            } else if (qName.equals(CONTENT_ITEMS)) {
                this.expandFolderTree(this.currFolderTree, this.m_section.getRootFolder());
            } else {
                s_log.debug((Object)("Unknown tag: " + name));
            }
        }
    }

    private ContentItemHelper getHelperClass(String classname) {
        if (!StringUtils.emptyString((String)classname)) {
            try {
                s_log.warn((Object)("Trying to create " + classname));
                Class<?> classDef = Class.forName(classname);
                Class[] args = new Class[]{class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = XMLContentItemHandler.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection};
                Object[] argv = new Object[]{this.m_section};
                Constructor<?> constructor = classDef.getConstructor(args);
                s_log.warn((Object)("Got constructor " + constructor.getName()));
                return (ContentItemHelper)constructor.newInstance(argv);
            }
            catch (InvocationTargetException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (InstantiationException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
            catch (Exception e) {
                throw new UncheckedWrapperException((Throwable)e);
            }
        }
        s_log.warn((Object)"Using default ContentItemHelper");
        return new ContentPageHelper(this.m_section);
    }

    public ContentType getContentType(String typeName) throws UncheckedWrapperException {
        ContentType type = null;
        s_log.debug((Object)("TypeName " + typeName));
        try {
            type = ContentType.findByAssociatedObjectType(typeName);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.installer.cannot_find_content_type").localize() + typeName, (Throwable)ex);
        }
        this.m_section.addContentType(type);
        this.m_section.save();
        s_log.debug((Object)("Content type is: " + type.getClassName()));
        return type;
    }

    private String validateTitle(String name) {
        Perl5Util util = new Perl5Util();
        String pattern = "/[^A-Za-z_0-9\\-]+ /";
        if (util.match(pattern, name)) {
            throw new InitializationException("The \"" + name + "\" name parameter must contain only alpha-numeric " + "characters, underscores, and/or hyphens.");
        }
        return name;
    }

    protected void expandFolderTree(FolderTree toClone, Folder toAttachTo) {
        this.cloneFolderTree(toClone, toAttachTo, toAttachTo, 1, true, true, true, 1);
    }

    protected void cloneFolderTree(FolderTree toClone, Folder toAttachTo, Folder parent, int cloneTime, boolean firstTime, boolean mainline, boolean clone, int depthTime) {
        if (clone && !firstTime) {
            int selfNumClone = toClone.getFolderHelper().getCloneCount();
            while (cloneTime < selfNumClone) {
                Folder clonedFolder = (Folder)toClone.getFolderHelper().cloneItem(cloneTime, parent);
                this.copyFolderItems(toClone, clonedFolder);
                this.cloneFolderTree(toClone, clonedFolder, parent, ++cloneTime, false, false, false, depthTime);
            }
        }
        if (!firstTime && depthTime < toClone.getFolderHelper().getDepth()) {
            this.cloneFolderTree(toClone, this.replicateFolder(toClone, toAttachTo), toAttachTo, 1, false, false, true, ++depthTime);
        }
        List subFolders = toClone.getSubTrees();
        for (int i = 0; i < subFolders.size(); ++i) {
            Folder newToAttachTo = mainline ? (Folder)((FolderTree)subFolders.get(i)).getFolderHelper().getContentItem() : this.replicateFolder((FolderTree)subFolders.get(i), toAttachTo);
            this.cloneFolderTree((FolderTree)subFolders.get(i), newToAttachTo, toAttachTo, 1, false, mainline, true, 1);
        }
        List childItems = toClone.getContentItems();
        for (int i = 0; i < childItems.size(); ++i) {
            this.autoCloneChild((xmlContentItem)childItems.get(i), toAttachTo);
        }
    }

    private void autoCloneChild(xmlContentItem child, Folder parent) {
        int numClone = child.getHelperClass().getCloneCount();
        for (int i = 1; i < numClone; ++i) {
            child.clone(i, parent, true);
        }
    }

    private Folder replicateFolder(FolderTree toCopy, Folder parent) {
        Folder newFolder = (Folder)toCopy.getFolderHelper().cloneItem(toCopy.getFolderHelper().getName(), parent, true);
        return this.copyFolderItems(toCopy, newFolder);
    }

    private Folder copyFolderItems(FolderTree toCopy, Folder copyTo) {
        List childContent = toCopy.getContentItems();
        for (int i = 0; i < childContent.size(); ++i) {
            xmlContentItem child = (xmlContentItem)childContent.get(i);
            String name = child.getHelperClass().getName();
            child.replicate(name, copyTo, true);
        }
        return copyTo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class xmlContentItem {
        private ContentItemHelper xml_page_helper;
        private Vector xml_assocs = new Vector();
        private xmlContentItem xml_parent_item;

        public void setHelperClass(String l_helperClass) {
            this.xml_page_helper = XMLContentItemHandler.this.getHelperClass(l_helperClass);
        }

        public ContentItemHelper getHelperClass() {
            return this.xml_page_helper;
        }

        public void setParentItem(xmlContentItem l_parent) {
            this.xml_parent_item = l_parent;
        }

        public xmlContentItem getParentItem() {
            return this.xml_parent_item;
        }

        public void setCloneCount(String l_count) {
            this.xml_page_helper.setCloneCount(Integer.parseInt(l_count));
        }

        public void setContentType(String l_objectType) {
            this.getHelperClass().setContentType(XMLContentItemHandler.this.getContentType(l_objectType).getClassName());
        }

        public void setName(String l_name) {
            s_log.debug((Object)("Setting Name to:" + l_name));
            this.getHelperClass().setName(l_name);
        }

        public void setAssociation(String assocName, xmlContentItem assoc) {
            Hashtable<String, xmlContentItem> newAssoc = new Hashtable<String, xmlContentItem>();
            newAssoc.put(assocName, assoc);
            this.xml_assocs.add(newAssoc);
        }

        public List getAssociations() {
            return this.xml_assocs;
        }

        public void create(boolean save) {
            this.getHelperClass().create(save);
        }

        public void save() {
            this.getHelperClass().save();
            s_log.debug((Object)"About to save all the associations");
            ContentItem theItem = this.getHelperClass().getContentItem();
            Iterator i = this.xml_assocs.iterator();
            while (i.hasNext()) {
                Map m_assoc = (Map)i.next();
                Iterator j = m_assoc.keySet().iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    xmlContentItem value = (xmlContentItem)m_assoc.get(key);
                    DataAssociation da = (DataAssociation)theItem.get(key);
                    value.getHelperClass().getContentItem().addToAssociation(da);
                    s_log.debug((Object)"Just saved a data association");
                }
            }
            theItem.save();
        }

        public ContentItem clone(int cloneNumber, Folder parent, boolean save) {
            return this.cloneItem("", cloneNumber, parent, save, false);
        }

        public ContentItem replicate(String name, Folder parent, boolean save) {
            return this.cloneItem(name, 0, parent, save, true);
        }

        private ContentItem cloneItem(String name, int cloneNumber, Folder parent, boolean save, boolean replicate) {
            if (replicate) {
                s_log.debug((Object)("About to replicate: " + name + " with parent: " + parent.getLabel()));
            } else {
                name = this.getHelperClass().cloneName(cloneNumber);
                s_log.debug((Object)("About to clone: " + name + " with parent: " + parent.getLabel()));
            }
            ContentItem clone = this.getHelperClass().cloneItem(name, parent, save);
            for (int i = 0; i < this.xml_assocs.size(); ++i) {
                Map m_assoc = (Map)this.xml_assocs.get(i);
                Iterator j = m_assoc.keySet().iterator();
                while (j.hasNext()) {
                    String key = (String)j.next();
                    xmlContentItem value = (xmlContentItem)m_assoc.get(key);
                    String cloneAssocName = replicate ? value.getHelperClass().getName() : value.getHelperClass().cloneName(cloneNumber);
                    ContentItem cloneValue = value.getHelperClass().cloneItem(cloneAssocName, parent, true);
                    s_log.debug((Object)("Value of item: " + this.getHelperClass().getContentItem()));
                    s_log.debug((Object)("Value of cloned item: " + clone));
                    s_log.debug((Object)("Value of association: " + value.getHelperClass().getContentItem()));
                    s_log.debug((Object)("Value of cloned association : " + cloneValue));
                    DataAssociation da = (DataAssociation)clone.get(key);
                    da.clear();
                    cloneValue.addToAssociation(da);
                    s_log.debug((Object)"Just saved a data association");
                }
            }
            clone.save();
            return clone;
        }
    }

    private class FolderTree {
        private List m_subFolders = new Vector();
        private List m_contentItems = new Vector();
        private FolderTree m_parentTree;
        private FolderHelper m_helper;

        public FolderTree(FolderHelper helper) {
            this.m_helper = helper;
        }

        public FolderHelper getFolderHelper() {
            return this.m_helper;
        }

        public void setParentTree(FolderTree parentTree) {
            this.m_parentTree = parentTree;
            if (parentTree != null && parentTree.getFolderHelper() != null) {
                this.m_helper.setParent((Folder)parentTree.getFolderHelper().create(false));
            }
        }

        public FolderTree getParentTree() {
            return this.m_parentTree;
        }

        public void addSubTree(FolderTree subTree) {
            this.m_subFolders.add(subTree);
        }

        public List getSubTrees() {
            return this.m_subFolders;
        }

        public void addContentItem(xmlContentItem item) {
            this.m_contentItems.add(item);
        }

        public List getContentItems() {
            return this.m_contentItems;
        }

        public boolean isRoot() {
            return this.m_parentTree == null;
        }
    }

    private class FolderHelper
    extends ContentItemHelper {
        int m_treeDepth = 0;

        public FolderHelper(ContentSection section) {
            super(section);
            this.setContentType("com.arsdigita.cms.Folder");
        }

        public void setDepth(int depth) {
            this.m_treeDepth = depth;
            s_log.debug((Object)("Depth is now " + this.m_treeDepth));
        }

        public int getDepth() {
            return this.m_treeDepth;
        }

        public ContentItem createContentItem(boolean save) {
            s_log.warn((Object)"creating folder");
            Folder folder = (Folder)super.createContentItem(false);
            folder.setLabel(folder.getName());
            this.setContentItem(folder);
            if (save) {
                this.save();
            }
            return folder;
        }

        public ContentItem cloneItem(String name, Folder parent, boolean save) {
            Folder folder = (Folder)super.cloneItem(name, parent, save);
            folder.setLabel(folder.getName());
            folder.save();
            return folder;
        }
    }
}

