/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.installer.xml.XMLContentItemHandler;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.util.ResourceManager;
import java.io.IOException;
import java.math.BigDecimal;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ContentItemLoader
extends BaseInitializer {
    private Configuration m_conf = new Configuration();
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$xml$ContentItemLoader == null ? (class$com$arsdigita$cms$installer$xml$ContentItemLoader = ContentItemLoader.class$("com.arsdigita.cms.installer.xml.ContentItemLoader")) : class$com$arsdigita$cms$installer$xml$ContentItemLoader));
    private static final String CONTENT_DEFINITION = "contentItemDef";
    private static final String SECTION = "section";
    static /* synthetic */ Class class$com$arsdigita$cms$installer$xml$ContentItemLoader;
    static /* synthetic */ Class class$java$lang$String;

    public ContentItemLoader() {
        this.m_conf.initParameter(CONTENT_DEFINITION, "Path to XML definition file for the contents of the content item", class$java$lang$String == null ? (class$java$lang$String = ContentItemLoader.class$("java.lang.String")) : class$java$lang$String);
        this.m_conf.initParameter(SECTION, "Content section where the content items should be created", class$java$lang$String == null ? (class$java$lang$String = ContentItemLoader.class$("java.lang.String")) : class$java$lang$String);
    }

    public String getContentSectionParam() {
        return (String)this.m_conf.getParameter(SECTION);
    }

    public String getContentDefinition() {
        return (String)this.m_conf.getParameter(CONTENT_DEFINITION);
    }

    public Configuration getConfiguration() {
        return this.m_conf;
    }

    private String getXMLFilePath(String xmlFile) {
        return ResourceManager.getInstance().getServletContext().getRealPath(xmlFile);
    }

    public void doStartup() {
        s_log.warn((Object)"Starting ContentItemLoader");
        TransactionContext txn = SessionManager.getSession().getTransactionContext();
        txn.beginTxn();
        String xmlFile = this.getXMLFilePath(this.getContentDefinition());
        ContentSection section = this.getContentSection();
        s_log.debug((Object)("Loading XMLFile: " + xmlFile));
        this.loadContentItems(xmlFile, section);
        txn.commitTxn();
    }

    public void doShutdown() {
    }

    public void validateNameParameter(String value) throws InitializationException {
        String pattern = "/[^A-Za-z_0-9\\-]+/";
        Perl5Util util = new Perl5Util();
        if (util.match("/[^A-Za-z_0-9\\-]+/", value)) {
            throw new InitializationException("The \"" + value + "\" name parameter must contain only alpha-numeric " + "characters, underscores, and/or hyphens.");
        }
    }

    public ContentSection getContentSection() throws InitializationException {
        String name = this.getContentSectionParam();
        this.validateNameParameter(name);
        BigDecimal rootNodeID = SiteNode.getRootSiteNode().getID();
        SiteNode node = null;
        try {
            node = SiteNode.getSiteNode((String)("/" + name));
        }
        catch (DataObjectNotFoundException ex) {
            throw new InitializationException((String)GlobalizationUtil.globalize("cms.installer.root_site_node_missing").localize(), (Throwable)ex);
        }
        if (rootNodeID.equals(node.getID())) {
            throw new InitializationException("The section does not exist");
        }
        ContentSection section = null;
        try {
            section = ContentSection.getSectionFromNode(node);
        }
        catch (DataObjectNotFoundException e) {
            throw new InitializationException((String)GlobalizationUtil.globalize("cms.installer.failed_to_update_the_default_content_section").localize());
        }
        return section;
    }

    public void loadContentItems(String path, ContentSection section) {
        XMLContentItemHandler handler = new XMLContentItemHandler(section);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser parser = spf.newSAXParser();
            parser.parse(path, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            s_log.error((Object)"error parsing content item config", (Throwable)e);
        }
        catch (SAXException e) {
            s_log.error((Object)"error parsing content item config", (Throwable)e);
        }
        catch (IOException e) {
            s_log.error((Object)"error parsing content item config", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

