/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class ImageDisplay
extends SimpleComponent {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/contenttypes/ui/ImageDisplay.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final ItemSelectionModel m_item;

    public ImageDisplay(ItemSelectionModel m) {
        this.m_item = m;
    }

    public final ItemSelectionModel getImageSelectionModel() {
        return this.m_item;
    }

    public void generateXML(PageState state, Element parent) {
        ImageAsset image;
        if (this.isVisible(state) && (image = this.getImageAsset(state)) != null) {
            Element element = new Element("cms:imageDisplay", "http://www.arsdigita.com/cms/1.0");
            this.generateImagePropertiesXML(image, state, element);
            this.exportAttributes(element);
            parent.addContent(element);
        }
    }

    protected void generateImagePropertiesXML(ImageAsset image, PageState state, Element element) {
        MimeType mimeType;
        BigDecimal height;
        element.addAttribute("name", image.getName());
        element.addAttribute("src", Utilities.getImageURL(image));
        BigDecimal width = image.getWidth();
        if (width != null) {
            element.addAttribute("width", width.toString());
        }
        if ((height = image.getHeight()) != null) {
            element.addAttribute("height", height.toString());
        }
        if ((mimeType = image.getMimeType()) != null) {
            element.addAttribute("mime_type", mimeType.getLabel());
        }
    }

    protected ImageAsset getImageAsset(PageState state) {
        ImageAsset image = (ImageAsset)this.m_item.getSelectedObject(state);
        return image;
    }
}

