/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemTemplateCollection;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateMapping;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class ItemTemplateMapping
extends TemplateMapping {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ItemTemplateMapping.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ItemTemplateMapping";
    public static final String ITEM = "item";
    public static final String TEMPLATE = "template";
    public static final String USE_CONTEXT = "useContext";
    private static final String CTX_QUERY_NAME = "com.arsdigita.cms.templatesInUseContexts";
    private static final String CTX_TYPE_QUERY_NAME = "com.arsdigita.cms.templatesInUseContextsWithType";
    private static final String CTX_QUERY_ITEM_ID = "itemID";
    private static final String CTX_QUERY_MAPPING = "mapping";
    private static final String CTX_MIME_TYPES_ID = "availableMimeTypes";

    public ItemTemplateMapping() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public ItemTemplateMapping(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ItemTemplateMapping(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ItemTemplateMapping(DataObject obj) {
        super(obj);
    }

    public ItemTemplateMapping(String type) {
        super(type);
    }

    public ContentSection getContentSection() {
        return this.getContentItem().getContentSection();
    }

    public final ContentItem getContentItem() {
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(ITEM)));
    }

    public final void setContentItem(ContentItem item) {
        Assert.assertNotNull((Object)item);
        this.setAssociation(ITEM, (DomainObject)item);
    }

    public ACSObject getParent() {
        return this.getContentItem();
    }

    public Boolean isDefault() {
        return Boolean.TRUE;
    }

    public void setDefault(Boolean b) {
    }

    public static ItemTemplateMapping getMapping(ContentItem item, String useContext) {
        return ItemTemplateMapping.getMapping(item, useContext, MimeType.loadMimeType((String)"text/x-jsp"));
    }

    public static ItemTemplateMapping getMapping(ContentItem item, String useContext, MimeType mimeType) {
        ItemTemplateCollection c = ItemTemplateMapping.getTemplates(item);
        c.addEqualsFilter(USE_CONTEXT, useContext);
        if (mimeType != null) {
            c.addEqualsFilter("template.mimeType.mimeType", mimeType.getMimeType());
        }
        if (!c.next()) {
            return null;
        }
        ItemTemplateMapping m = (ItemTemplateMapping)c.getDomainObject();
        Assert.assertTrue((!c.next() ? 1 : 0) != 0);
        c.close();
        return m;
    }

    public static ItemTemplateMapping getMapping(ContentItem item, String useContext, Template template) {
        ItemTemplateCollection c = ItemTemplateMapping.getTemplates(item);
        c.addEqualsFilter(USE_CONTEXT, useContext);
        c.addEqualsFilter("template.id", template.getID());
        if (!c.next()) {
            return null;
        }
        ItemTemplateMapping m = (ItemTemplateMapping)c.getDomainObject();
        c.close();
        return m;
    }

    protected static Template getTemplate(ContentItem item, String useContext) {
        return ItemTemplateMapping.getTemplate(item, useContext, MimeType.loadMimeType((String)"text/x-jsp"));
    }

    protected static Template getTemplate(ContentItem item, String useContext, MimeType mimeType) {
        ItemTemplateMapping m = ItemTemplateMapping.getMapping(item, useContext, mimeType);
        if (m == null) {
            return null;
        }
        return m.getTemplate();
    }

    protected static ItemTemplateCollection getTemplates(ContentItem item) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ItemTemplateCollection c = new ItemTemplateCollection(da);
        c.addEqualsFilter("item.id", item.getID());
        c.addOrder(USE_CONTEXT);
        return c;
    }

    protected static ItemTemplateCollection getUseContexts(ContentItem item) {
        DataQuery q = SessionManager.getSession().retrieveQuery(CTX_QUERY_NAME);
        q.setParameter(CTX_QUERY_ITEM_ID, (Object)item.getID());
        q.alias(USE_CONTEXT, USE_CONTEXT);
        DataQueryDataCollectionAdapter da = new DataQueryDataCollectionAdapter(q, CTX_QUERY_MAPPING);
        return new ItemTemplateCollection((DataCollection)da);
    }

    protected static ItemTemplateCollection getContextsWithTypes(ContentItem item) {
        DataQuery q = SessionManager.getSession().retrieveQuery(CTX_TYPE_QUERY_NAME);
        q.setParameter(CTX_QUERY_ITEM_ID, (Object)item.getID());
        q.setParameter(CTX_MIME_TYPES_ID, Template.SUPPORTED_MIME_TYPES.keySet());
        q.alias(USE_CONTEXT, USE_CONTEXT);
        q.alias("mimeType", "mimeType");
        q.addOrder(USE_CONTEXT);
        DataQueryDataCollectionAdapter da = new DataQueryDataCollectionAdapter(q, CTX_QUERY_MAPPING);
        return new ItemTemplateCollection((DataCollection)da);
    }

    protected static ItemTemplateCollection getItems(Template template) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ItemTemplateCollection c = new ItemTemplateCollection(da);
        c.addEqualsFilter("template.id", template.getID());
        c.addOrder(USE_CONTEXT);
        return c;
    }
}

