/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.TemplateContext;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.dispatcher.ItemDelegatedURLPatternGenerator;
import com.arsdigita.cms.dispatcher.ItemTemplatePatternGenerator;
import com.arsdigita.cms.dispatcher.ItemURLFinder;
import com.arsdigita.cms.publishToFile.PublishToFileListener;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.cms.search.ContentTypeFilterType;
import com.arsdigita.cms.search.CreationDateFilterType;
import com.arsdigita.cms.search.CreationUserFilterType;
import com.arsdigita.cms.search.IntermediaQueryEngine;
import com.arsdigita.cms.search.LastModifiedDateFilterType;
import com.arsdigita.cms.search.LastModifiedUserFilterType;
import com.arsdigita.cms.search.LaunchDateFilterType;
import com.arsdigita.cms.search.LuceneQueryEngine;
import com.arsdigita.cms.search.VersionFilterType;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.db.DbHelper;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectInstantiator;
import com.arsdigita.domain.xml.TraversalHandler;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLFinderNotFoundException;
import com.arsdigita.kernel.URLService;
import com.arsdigita.mimetypes.image.ImageSizerFactory;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;
import com.arsdigita.persistence.pdl.PDLFilter;
import com.arsdigita.persistence.pdl.PDLSource;
import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.DomainInitEvent;
import com.arsdigita.runtime.LegacyInitializer;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.search.FilterType;
import com.arsdigita.search.IndexerType;
import com.arsdigita.search.QueryEngine;
import com.arsdigita.search.QueryEngineRegistry;
import com.arsdigita.search.filters.CategoryFilterType;
import com.arsdigita.search.filters.PermissionFilterType;
import com.arsdigita.templating.PatternGenerator;
import com.arsdigita.templating.PatternStylesheetResolver;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import com.arsdigita.xml.XML;
import java.io.InputStream;
import org.xml.sax.helpers.DefaultHandler;

public class Initializer
extends CompoundInitializer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/Initializer.java#14 $$Author: dan $$DateTime: 2004/05/10 10:31:08 $";

    public Initializer() {
        String url = RuntimeConfig.getConfig().getJDBCURL();
        int database = DbHelper.getDatabaseFromURL((String)url);
        this.add((com.arsdigita.runtime.Initializer)new PDLInitializer((PDLSource)new ManifestSource("ccm-cms.pdl.mf", (PDLFilter)new NameFilter(DbHelper.getDatabaseSuffix((int)database), "pdl"))));
        this.add((com.arsdigita.runtime.Initializer)new LegacyInitializer("com/arsdigita/cms/enterprise.init"));
    }

    public void init(DomainInitEvent e) {
        super.init(e);
        LanguageUtil.setSupportedLanguages(ContentSection.getConfig().getLanguages());
        URLService.registerFinder((String)"com.arsdigita.cms.ContentPage", (URLFinder)new ItemURLFinder());
        URLService.registerFinder((String)"com.arsdigita.cms.ContentBundle", (URLFinder)new ItemURLFinder());
        URLService.registerFinder((String)"com.arsdigita.cms.Template", (URLFinder)new ItemURLFinder());
        URLService.registerFinder((String)"com.arsdigita.cms.contenttypes.Link", (URLFinder)new URLFinder(){

            public String find(OID oid, String context) throws NoValidURLException {
                return this.find(oid);
            }

            public String find(OID oid) throws NoValidURLException {
                Link link;
                try {
                    link = (Link)DomainObjectFactory.newInstance((OID)oid);
                }
                catch (DataObjectNotFoundException ex) {
                    throw new NoValidURLException("Cannot find an object with oid: " + oid);
                }
                if ("externalLink".equals(link.getTargetType())) {
                    return link.getTargetURI();
                }
                ContentItem target = link.getTargetItem();
                try {
                    return URLService.locate((OID)target.getOID());
                }
                catch (URLFinderNotFoundException ex) {
                    throw new UncheckedWrapperException((Throwable)ex);
                }
            }
        });
        ImageSizerFactory.initialize();
        this.registerInstantiators(e.getFactory());
        this.registerLuceneEngines();
        this.registerIntermediaEngines();
        this.registerPatternGenerators();
        XML.parse((InputStream)ContentSection.getConfig().getItemAdapters(), (DefaultHandler)new TraversalHandler());
        try {
            QueueManager.setListener((PublishToFileListener)ContentSection.getConfig().getPublishToFileClass().newInstance());
        }
        catch (InstantiationException ex) {
            throw new UncheckedWrapperException("Failed to instantiate the listener class", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new UncheckedWrapperException("Couldn't access the listener class", (Throwable)ex);
        }
    }

    private void registerPatternGenerators() {
        PatternStylesheetResolver.registerPatternGenerator((String)"item_template_oid", (PatternGenerator)new ItemTemplatePatternGenerator());
        PatternStylesheetResolver.registerPatternGenerator((String)"item_delegated_url", (PatternGenerator)new ItemDelegatedURLPatternGenerator());
    }

    private void registerInstantiators(DomainObjectFactory f) {
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.workflow.CMSTask", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new CMSTask(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workflow.simple.Workflow", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new Workflow(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.workflow.simple.WorkflowTemplate", (DomainObjectInstantiator)new ACSObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new WorkflowTemplate(dataObject);
            }
        });
        DomainObjectFactory.registerInstantiator((String)"com.arsdigita.cms.TemplateContext", (DomainObjectInstantiator)new DomainObjectInstantiator(){

            public DomainObject doNewInstance(DataObject dataObject) {
                return new TemplateContext(dataObject);
            }

            public DomainObjectInstantiator resolveInstantiator(DataObject obj) {
                return this;
            }
        });
    }

    private void registerLuceneEngines() {
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.LUCENE, (FilterType[])new FilterType[]{new VersionFilterType()}, (QueryEngine)new LuceneQueryEngine());
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.LUCENE, (FilterType[])new FilterType[]{new ContentTypeFilterType(), new VersionFilterType()}, (QueryEngine)new LuceneQueryEngine());
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.LUCENE, (FilterType[])new FilterType[]{new ContentTypeFilterType(), new VersionFilterType(), new LastModifiedDateFilterType(), new CreationDateFilterType(), new CreationUserFilterType(), new LastModifiedUserFilterType()}, (QueryEngine)new LuceneQueryEngine());
    }

    private void registerIntermediaEngines() {
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.INTERMEDIA, (FilterType[])new FilterType[]{new PermissionFilterType(), new VersionFilterType()}, (QueryEngine)new IntermediaQueryEngine());
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.INTERMEDIA, (FilterType[])new FilterType[]{new PermissionFilterType(), new ContentTypeFilterType(), new CategoryFilterType(), new VersionFilterType()}, (QueryEngine)new IntermediaQueryEngine());
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.INTERMEDIA, (FilterType[])new FilterType[]{new PermissionFilterType(), new ContentTypeFilterType(), new CategoryFilterType(), new VersionFilterType(), new LaunchDateFilterType()}, (QueryEngine)new IntermediaQueryEngine());
        QueryEngineRegistry.registerEngine((IndexerType)IndexerType.INTERMEDIA, (FilterType[])new FilterType[]{new PermissionFilterType(), new ContentTypeFilterType(), new CategoryFilterType(), new VersionFilterType(), new LaunchDateFilterType(), new LastModifiedDateFilterType(), new CreationDateFilterType(), new CreationUserFilterType(), new LastModifiedUserFilterType()}, (QueryEngine)new IntermediaQueryEngine());
    }
}

