/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContentType
extends ACSObject {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentType.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentType";
    public static final String OBJECT_TYPE = "associatedObjectType";
    public static final String LABEL = "label";
    public static final String DESCRIPTION = "description";
    public static final String CLASSNAME = "className";
    public static final String IS_INTERNAL = "isInternal";
    public static final String AUTHORING_KIT = "authoringKit";
    public static final String ITEM_FORM_ID = "itemFormID";
    public static final String ITEM_FORM = "itemForm";
    private static List s_xsl = new ArrayList();

    public ContentType() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ContentType(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentType(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected ContentType(String type) {
        super(type);
    }

    public ContentType(DataObject obj) {
        super(obj);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    protected void beforeSave() {
        if (this.isInternal() == null) {
            this.setInternal(false);
        }
        super.beforeSave();
    }

    public String getAssociatedObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public void setAssociatedObjectType(String objType) {
        this.set(OBJECT_TYPE, objType);
    }

    public String getLabel() {
        return (String)this.get(LABEL);
    }

    public void setLabel(String label) {
        this.set(LABEL, label);
    }

    public String getDescription() {
        return (String)this.get(DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION, description);
    }

    public String getClassName() {
        return (String)this.get(CLASSNAME);
    }

    public void setClassName(String className) {
        this.set(CLASSNAME, className);
    }

    public Boolean isInternal() {
        return (Boolean)this.get(IS_INTERNAL);
    }

    public void setInternal(boolean isInternal) {
        this.set(IS_INTERNAL, isInternal ? Boolean.TRUE : Boolean.FALSE);
    }

    public AuthoringKit getAuthoringKit() {
        DataObject kit = (DataObject)this.get(AUTHORING_KIT);
        if (kit == null) {
            return null;
        }
        return new AuthoringKit(kit);
    }

    public AuthoringKit createAuthoringKit() {
        return this.createAuthoringKit(null);
    }

    public AuthoringKit createAuthoringKit(String createComponent) {
        if (this.getAuthoringKit() == null) {
            AuthoringKit kit = new AuthoringKit();
            kit.setContentType(this);
            if (createComponent != null) {
                kit.setCreateComponent(createComponent);
            }
            return kit;
        }
        throw new RuntimeException("An AuthorigKit exists for this ContentType.");
    }

    public BigDecimal getItemFormID() {
        return (BigDecimal)this.get(ITEM_FORM_ID);
    }

    public void setItemFormID(BigDecimal itemFormID) {
        this.set(ITEM_FORM_ID, itemFormID);
    }

    public PersistentForm getItemForm() throws DataObjectNotFoundException {
        DataObject pForm = (DataObject)this.get(ITEM_FORM);
        if (pForm == null) {
            return null;
        }
        return new PersistentForm(pForm);
    }

    public static ContentType findByAssociatedObjectType(String objType) throws DataObjectNotFoundException {
        ContentTypeCollection types = ContentType.getAllContentTypes();
        types.addFilter("associatedObjectType = :type").set("type", (Object)objType);
        if (types.next()) {
            ContentType type = types.getContentType();
            types.close();
            return type;
        }
        types.close();
        throw new DataObjectNotFoundException("No matching content type for object type " + objType);
    }

    public static ContentTypeCollection getAllContentTypes() {
        return ContentType.getAllContentTypes(true);
    }

    public static ContentTypeCollection getUserDefinedContentTypes() {
        return ContentType.getAllContentTypes(false);
    }

    private static ContentTypeCollection getAllContentTypes(boolean internal) {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ContentTypeCollection types = new ContentTypeCollection(da);
        if (!internal) {
            types.addFilter("isInternal = '0'");
        }
        return types;
    }

    public static ContentTypeCollection getRegisteredContentTypes() {
        String query = "com.arsdigita.cms.registeredContentTypes";
        DataQuery dq = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.registeredContentTypes");
        DataQueryDataCollectionAdapter dc = new DataQueryDataCollectionAdapter(dq, "type");
        return new ContentTypeCollection((DataCollection)dc);
    }

    public static void registerXSLFile(ContentType type, String path) {
        s_xsl.add(new XSLEntry(type, path));
    }

    public static void unregisterXSLFile(ContentType type, String path) {
        s_xsl.remove(new XSLEntry(type, path));
    }

    public static Iterator getXSLFileURLs() {
        return new EntryIterator(s_xsl.iterator());
    }

    private static class XSLEntry {
        private ContentType m_type;
        private String m_path;

        public XSLEntry(ContentType type, String path) {
            this.m_type = type;
            this.m_path = path;
        }

        public ContentType getType() {
            return this.m_type;
        }

        public String getPath() {
            return this.m_path;
        }

        public boolean equals(Object o) {
            if (!(o instanceof XSLEntry)) {
                return false;
            }
            XSLEntry e = (XSLEntry)o;
            return this.m_path.equals(e.m_path) && this.m_type.equals((Object)e.m_type);
        }

        public int hashCode() {
            return this.m_path.hashCode() + this.m_type.hashCode();
        }
    }

    private static class EntryIterator
    implements Iterator {
        private Iterator m_inner;

        public EntryIterator(Iterator inner) {
            this.m_inner = inner;
        }

        public boolean hasNext() {
            return this.m_inner.hasNext();
        }

        public Object next() {
            XSLEntry entry = (XSLEntry)this.m_inner.next();
            String path = entry.getPath();
            try {
                return new URL(Web.getConfig().getDefaultScheme(), Web.getConfig().getHost().getName(), Web.getConfig().getHost().getPort(), path);
            }
            catch (MalformedURLException ex) {
                throw new UncheckedWrapperException("path malformed" + path, (Throwable)ex);
            }
        }

        public void remove() {
            this.m_inner.remove();
        }
    }
}

