/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.caching.CacheTable;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.ContentItemDispatcher;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.dispatcher.TemplateResolver;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.publishToFile.LocalRequestPassword;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCache;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.AbstractTransactionListener;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.TransactionListener;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Versions;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ContentSectionServlet
extends BaseApplicationServlet {
    private static final String[] WELCOME_FILES = new String[]{"index.jsp", "index.html"};
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ContentSectionServlet == null ? (class$com$arsdigita$cms$ContentSectionServlet = ContentSectionServlet.class$("com.arsdigita.cms.ContentSectionServlet")) : class$com$arsdigita$cms$ContentSectionServlet));
    private ContentItemDispatcher m_disp = new ContentItemDispatcher();
    public static Map s_itemResolverCache = Collections.synchronizedMap(new HashMap());
    private static Map s_itemURLCacheMap = null;
    public static final String PREVIEW = "/preview";
    public static final String FILE_SUFFIX = ".jsp";
    public static final String INDEX_FILE = "/index";
    public static final String CONTENT_ITEM = "com.arsdigita.cms.dispatcher.item";
    public static final String CONTENT_SECTION = "com.arsdigita.cms.dispatcher.section";
    public static final String XML_SUFFIX = ".xml";
    public static final String XML_MODE = "xmlMode";
    public static final String MEDIA_TYPE = "templateContext";
    private static boolean s_cacheItems = true;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSectionServlet;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentSection;

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        ItemResolver itemResolver;
        ContentItem item;
        ContentSection section = (ContentSection)app;
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Resolving item URL " + url));
        }
        if ((item = this.getItem(section, url, itemResolver = this.getItemResolver(section))) != null) {
            String param = sreq.getParameter("transID");
            if (param != null) {
                Session ssn = SessionManager.getSession();
                TransactionContext txn = ssn.getTransactionContext();
                txn.addTransactionListener((TransactionListener)new AbstractTransactionListener(){

                    public void beforeCommit(TransactionContext txn) {
                        Assert.fail((String)"uncommittable transaction");
                    }
                });
                Kernel.getContext().getTransaction().setCommitRequested(false);
                BigInteger transID = new BigInteger(param);
                Versions.rollback((OID)item.getOID(), (BigInteger)transID);
            }
            this.serveItem(sreq, sresp, section, item);
        } else {
            RequestDispatcher rd;
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"NOT serving content item");
            }
            sreq.setAttribute(CONTENT_SECTION, (Object)section);
            String packageURL = ctx.getPageBase() + ctx.getRemainingURLPart();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Forwarding onto file " + packageURL));
            }
            if (packageURL.endsWith("/")) {
                for (int i = 0; i < WELCOME_FILES.length; ++i) {
                    RequestDispatcher rd2;
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Trying welcome resource " + packageURL + WELCOME_FILES[i]));
                    }
                    if ((rd2 = DispatcherHelper.getRequestContext((HttpServletRequest)sreq).getServletContext().getRequestDispatcher(packageURL + WELCOME_FILES[i])) == null || DispatcherHelper.getRequestContext((HttpServletRequest)sreq).getServletContext().getResource(packageURL + WELCOME_FILES[i]) == null) continue;
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Got dispatcher " + rd2));
                    }
                    sreq = DispatcherHelper.restoreOriginalRequest((HttpServletRequest)sreq);
                    rd2.forward((ServletRequest)sreq, (ServletResponse)sresp);
                    return;
                }
            }
            if ((rd = DispatcherHelper.getRequestContext((HttpServletRequest)sreq).getServletContext().getRequestDispatcher(packageURL)) != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Got dispatcher " + rd));
                }
                sreq = DispatcherHelper.restoreOriginalRequest((HttpServletRequest)sreq);
                rd.forward((ServletRequest)sreq, (ServletResponse)sresp);
            } else {
                sresp.sendError(404, packageURL + " not found on this server.");
            }
        }
    }

    private void serveItem(HttpServletRequest sreq, HttpServletResponse sresp, ContentSection section, ContentItem item) throws ServletException, IOException {
        int maxAge;
        Date endDate;
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"serving content item");
        }
        RequestContext ctx = DispatcherHelper.getRequestContext();
        String url = ctx.getRemainingURLPart();
        ItemResolver itemResolver = this.getItemResolver(section);
        ACSObjectCache.set((ServletRequest)sreq, (ACSObject)item);
        sreq.setAttribute(CONTENT_ITEM, (Object)item);
        TemplateResolver templateResolver = this.m_disp.getTemplateResolver(section);
        String templateURL = url;
        if (!templateURL.startsWith("/")) {
            templateURL = "/" + templateURL;
        }
        if (templateURL.startsWith(PREVIEW)) {
            templateURL = templateURL.substring(PREVIEW.length());
        }
        String sTemplateContext = itemResolver.getTemplateFromURL(templateURL);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("setting template context to " + sTemplateContext));
        }
        templateResolver.setTemplateContext(sTemplateContext, sreq);
        Lifecycle cycle = item.getLifecycle();
        int expires = DispatcherHelper.getDefaultCacheExpiry();
        if (cycle != null && (endDate = cycle.getEndDate()) != null && (maxAge = (int)((endDate.getTime() - System.currentTimeMillis()) / 1000L)) < expires) {
            expires = maxAge;
        }
        if (s_cacheItems && item.isLiveVersion()) {
            SecurityManager sm = new SecurityManager(section);
            if (sm.canAccess((User)null, "public_pages", item)) {
                DispatcherHelper.cacheForWorld((HttpServletResponse)sresp, (int)expires);
            } else {
                DispatcherHelper.cacheForUser((HttpServletResponse)sresp, (int)expires);
            }
        } else {
            DispatcherHelper.cacheDisable((HttpServletResponse)sresp);
        }
        this.m_disp.dispatch(sreq, sresp, ctx);
    }

    public ItemResolver getItemResolver(ContentSection section) {
        String path = section.getPath();
        ItemResolver ir = (ItemResolver)s_itemResolverCache.get(path);
        if (ir == null) {
            ir = section.getItemResolver();
            s_itemResolverCache.put(path, ir);
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("using ItemResolver " + ir.getClass().getName()));
        }
        return ir;
    }

    public ContentItem getItem(ContentSection section, String url, ItemResolver itemResolver) {
        ContentItem item;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getting item at url " + url));
        }
        HttpServletRequest request = Web.getRequest();
        if (url.endsWith(XML_SUFFIX)) {
            request.setAttribute(XML_MODE, (Object)Boolean.TRUE);
            s_log.debug((Object)"StraightXML Requested");
            url = "/" + url.substring(0, url.length() - XML_SUFFIX.length());
        } else {
            request.setAttribute(XML_MODE, (Object)Boolean.FALSE);
            if (url.endsWith(FILE_SUFFIX)) {
                url = "/" + url.substring(0, url.length() - FILE_SUFFIX.length());
            } else if (url.endsWith("/")) {
                url = "/" + url.substring(0, url.length() - 1);
            }
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        SecurityManager sm = new SecurityManager(section);
        boolean hasPermission = true;
        boolean preview = false;
        if (url.startsWith(PREVIEW)) {
            url = url.substring(PREVIEW.length());
            preview = true;
        }
        if (preview) {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"Trying to get item for PREVIEW");
            }
            if ((item = itemResolver.getItem(section, url, "preview")) != null) {
                hasPermission = sm.canAccess(request, "preview_pages", item);
            }
        } else {
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)"Trying to get LIVE item");
            }
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Trying to get content item for URL " + url + " from cache"));
            }
            if ((item = ContentSectionServlet.itemURLCacheGet(section, url)) == null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Did not find content item in cache, so trying to retrieve and cache...");
                }
                item = itemResolver.getItem(section, url, "live");
                ContentSectionServlet.itemURLCachePut(section, url, item);
            } else if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Found content item in cache");
            }
            if (s_log.isDebugEnabled() && item != null) {
                s_log.debug((Object)("Sanity check: item.getPath() is " + item.getPath()));
            }
            if (item != null) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"Content Item is not null");
                }
                if (hasPermission = sm.canAccess(request, "public_pages", item)) {
                    // empty if block
                }
            }
        }
        if (item == null && url.endsWith(INDEX_FILE)) {
            if (item == null && s_log.isInfoEnabled()) {
                s_log.info((Object)"no item found");
            }
            url = url.substring(0, url.length() - INDEX_FILE.length());
            if (s_log.isInfoEnabled()) {
                s_log.info((Object)("Attempting to match folder " + url));
            }
            if ((item = itemResolver.getItem(section, url, "live")) != null) {
                hasPermission = sm.canAccess(request, "public_pages", item);
            }
        }
        if (!hasPermission && !LocalRequestPassword.validLocalRequest(request)) {
            throw new AccessDeniedException();
        }
        return item;
    }

    public ContentItem getItem(ContentSection section, String url) {
        ItemResolver itemResolver = this.getItemResolver(section);
        return this.getItem(section, url, itemResolver);
    }

    private static synchronized void itemURLCachePut(ContentSection section, String sURL, BigDecimal itemID) {
        ContentSectionServlet.getItemURLCache(section).put(sURL, (Object)itemID);
    }

    public static synchronized void itemURLCachePut(ContentSection section, String sURL, ContentItem item) {
        if (sURL == null || item == null) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("adding cached entry for url " + sURL));
        }
        ContentSectionServlet.itemURLCachePut(section, sURL, item.getID());
    }

    public static synchronized void itemURLCacheRemove(ContentSection section, String sURL) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("removing cached entry for url " + sURL));
        }
        ContentSectionServlet.getItemURLCache(section).remove(sURL);
    }

    public static ContentItem itemURLCacheGet(ContentSection section, String sURL) {
        BigDecimal itemID = (BigDecimal)ContentSectionServlet.getItemURLCache(section).get(sURL);
        if (itemID == null) {
            return null;
        }
        try {
            return (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemID));
        }
        catch (DataObjectNotFoundException donfe) {
            return null;
        }
    }

    private static synchronized CacheTable getItemURLCache(ContentSection section) {
        Assert.exists((Object)((Object)section), (Class)(class$com$arsdigita$cms$ContentSection == null ? (class$com$arsdigita$cms$ContentSection = ContentSectionServlet.class$("com.arsdigita.cms.ContentSection")) : class$com$arsdigita$cms$ContentSection));
        if (s_itemURLCacheMap == null) {
            ContentSectionServlet.initializeItemURLCache();
        }
        return (CacheTable)s_itemURLCacheMap.get(section.getPath());
    }

    private static synchronized void initializeItemURLCache() {
        ContentSectionCollection sections = ContentSection.getAllSections();
        s_itemURLCacheMap = new HashMap();
        while (sections.next()) {
            ContentSection section = sections.getContentSection();
            String idStr = section.getID().toString();
            String path = section.getPath();
            CacheTable itemURLCache = new CacheTable("ContentSectionServletItemURLCache" + idStr);
            s_itemURLCacheMap.put(path, itemURLCache);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

