/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.auditing.AuditingObserver;
import com.arsdigita.auditing.BasicAuditTrail;
import com.arsdigita.categorization.CategorizedObject;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.cms.ObjectCopier;
import com.arsdigita.cms.PublishedLink;
import com.arsdigita.cms.VersionCopier;
import com.arsdigita.cms.VersionUpdater;
import com.arsdigita.cms.contenttypes.ContentGroupAssociation;
import com.arsdigita.cms.contenttypes.Link;
import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.lifecycle.LifecycleService;
import com.arsdigita.cms.publishToFile.QueueManager;
import com.arsdigita.domain.AbstractDomainObjectObserver;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObjectObserver;
import com.arsdigita.globalization.GlobalizationException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.DataQueryDataCollectionAdapter;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Reporter;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.versioning.VersionedACSObject;
import com.arsdigita.versioning.Versions;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContentItem
extends VersionedACSObject
implements CustomCopy {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ContentItem.java#106 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem));
    private static final Logger s_logDenorm = Logger.getLogger((String)((class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$("com.arsdigita.cms.ContentItem")) : class$com$arsdigita$cms$ContentItem).getName() + ".Denorm"));
    private static final String MODEL = "com.arsdigita.cms";
    private static final String QUERY_PENDING_ITEMS = "com.arsdigita.cms.getPendingSortedByLifecycle";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ContentItem";
    public static final String DRAFT = "draft";
    public static final String LIVE = "live";
    public static final String PENDING = "pending";
    public static final String ANCESTORS = "ancestors";
    public static final String PARENT = "parent";
    public static final String CHILDREN = "contentChildren";
    public static final String CONTENT_TYPE = "type";
    public static final String VERSION = "version";
    public static final String NAME = "name";
    public static final String LANGUAGE = "language";
    public static final String AUDITING = "auditing";
    public static final String DRAFT_VERSION = "masterVersion";
    public static final String VERSIONS = "slaveVersions";
    public static final String CONTENT_SECTION = "section";
    private static final String PUBLISH_LISTENER_CLASS = (class$com$arsdigita$cms$lifecycle$PublishLifecycleListener == null ? (class$com$arsdigita$cms$lifecycle$PublishLifecycleListener = ContentItem.class$("com.arsdigita.cms.lifecycle.PublishLifecycleListener")) : class$com$arsdigita$cms$lifecycle$PublishLifecycleListener).getName();
    private VersionCache m_pending;
    private VersionCache m_live;
    private boolean m_wasNew;
    private Reporter m_reporter;
    private BasicAuditTrail m_audit_trail;
    private static DomainObjectObserver s_parentObs = new AbstractDomainObjectObserver(){

        public void set(DomainObject dobj, String name, Object old, Object newVal) {
            if (ContentItem.PARENT.equals(name)) {
                ContentItem ci = (ContentItem)dobj;
                if (newVal == null) {
                    PermissionService.setContext((ACSObject)ci, (ACSObject)ci.getContentSection());
                } else {
                    PermissionService.setContext((OID)ci.getOID(), (OID)((DataObject)newVal).getOID());
                }
            }
        }
    };
    static /* synthetic */ Class class$com$arsdigita$cms$ContentItem;
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$PublishLifecycleListener;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$Lifecycle;
    static /* synthetic */ Class class$com$arsdigita$globalization$Locale;

    public ContentItem() {
        this(BASE_DATA_OBJECT_TYPE);
        s_log.debug((Object)"Undergoing creation");
    }

    public ContentItem(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ContentItem(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ContentItem(DataObject obj) {
        super(obj);
    }

    public ContentItem(String type) {
        super(type);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Content item " + this + " created with type " + type));
        }
    }

    protected void initialize() {
        super.initialize();
        this.addObserver(s_parentObs);
        DataObject dataObj = (DataObject)this.get(AUDITING);
        this.m_audit_trail = dataObj != null ? new BasicAuditTrail(dataObj) : BasicAuditTrail.retrieveForACSObject((ACSObject)this);
        this.addObserver((DomainObjectObserver)new AuditingObserver(this.m_audit_trail));
        this.m_pending = new VersionCache();
        this.m_live = new VersionCache();
        this.m_reporter = new Reporter(s_log, (Object)this, class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$cms$ContentItem);
        if (this.isNew()) {
            s_log.debug((Object)(this + " is being newly created; " + "marking it as a draft version"));
            this.m_wasNew = true;
            this.set(VERSION, DRAFT);
            this.setMaster(this);
            try {
                ContentType type = ContentType.findByAssociatedObjectType(this.getSpecificObjectType());
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Set content type for " + this + " to " + (Object)((Object)type)));
                }
                this.setContentType(type);
            }
            catch (DataObjectNotFoundException donfe) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("No content type found for " + this));
                }
            }
        } else if (Assert.isEnabled()) {
            Assert.exists((Object)this.getVersion(), (Class)(class$java$lang$String == null ? (class$java$lang$String = ContentItem.class$("java.lang.String")) : class$java$lang$String));
        }
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Object get(String key) {
        return super.get(key);
    }

    public void set(String key, Object value) {
        super.set(key, value);
    }

    protected void beforeSave() {
        this.m_wasNew = this.isNew();
        super.beforeSave();
        if (this.m_wasNew && this.getContentSection() == null) {
            this.setDefaultContentSection();
        }
    }

    protected void afterSave() {
        super.afterSave();
        if (this.m_wasNew) {
            ACSObject parent = this.getParent();
            if (parent == null) {
                PermissionService.setContext((ACSObject)this, (ACSObject)this.getContentSection());
            } else {
                PermissionService.setContext((ACSObject)this, (ACSObject)parent);
            }
        }
    }

    private void setDefaultContentSection() {
        s_log.debug((Object)"Setting the default content section");
        String version = this.getVersion();
        if (version != null && version.equals(DRAFT)) {
            ACSObject parent = this.getParent();
            if (parent != null && parent instanceof Folder) {
                this.setContentSection(((ContentItem)parent).getContentSection());
            } else {
                s_log.debug((Object)"The item's parent is not a folder; I am not setting the default content section");
            }
        } else {
            s_log.debug((Object)"The item's version is null or it is not draft; doing nothing");
        }
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public void setName(String value) {
        Assert.exists((Object)value, (Class)(class$java$lang$String == null ? (class$java$lang$String = ContentItem.class$("java.lang.String")) : class$java$lang$String));
        this.set(NAME, value);
        this.m_reporter.mutated(NAME);
    }

    public ACSObject getParent() {
        return (ACSObject)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(PARENT)));
    }

    public final void setParent(ACSObject object) {
        this.setAssociation(PARENT, (DomainObject)object);
        this.m_reporter.mutated(PARENT);
    }

    public final ItemCollection getChildren() {
        DataAssociationCursor cursor = ((DataAssociation)super.get(CHILDREN)).cursor();
        return new ItemCollection((DataCollection)cursor);
    }

    public ContentType getContentType() {
        DataObject type = (DataObject)this.get(CONTENT_TYPE);
        if (type == null) {
            return null;
        }
        return new ContentType(type);
    }

    public void setContentType(ContentType type) {
        this.setAssociation(CONTENT_TYPE, (DomainObject)type);
        this.m_reporter.mutated("contentType");
    }

    public ContentSection getContentSection() {
        return (ContentSection)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(CONTENT_SECTION)));
    }

    public final void setContentSection(ContentSection section) {
        this.setAssociation(CONTENT_SECTION, (DomainObject)section);
        this.m_reporter.mutated("contentSection");
    }

    public String getPath() {
        return this.getPathNoJsp();
    }

    public String getPathNoJsp() {
        StringBuffer result = new StringBuffer(400);
        ItemCollection coll = this.getPathInfo(true);
        coll.next();
        s_log.debug((Object)"Get item path not jsp");
        boolean first = true;
        while (coll.next()) {
            if (!first) {
                result.append('/');
            } else {
                first = false;
            }
            s_log.debug((Object)("Add " + coll.getName()));
            result.append(coll.getName());
            s_log.debug((Object)("Now " + result));
        }
        return result.toString();
    }

    public ItemCollection getPathInfo() {
        return this.getPathInfo(false);
    }

    public ItemCollection getPathInfo(boolean includeSelf) {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        String ids = (String)this.get(ANCESTORS);
        if (ids == null) {
            if (includeSelf) {
                collection.addEqualsFilter("id", (Object)this.getID());
                return new ItemCollection(collection);
            }
            collection.addFilter("1=2");
            return new ItemCollection(collection);
        }
        int iLength = includeSelf ? ids.length() : ids.length() - 1;
        ArrayList<String> ancestors = new ArrayList<String>();
        int iIndex = 0;
        int i = ids.indexOf("/", 0);
        while (i != -1) {
            ancestors.add(ids.substring(0, i + 1));
            iIndex = i + 1;
            i = ids.indexOf("/", iIndex);
        }
        Filter filter = collection.addFilter("ancestors in :ancestors");
        filter.set(ANCESTORS, ancestors);
        collection.addOrder(ANCESTORS);
        if (!includeSelf) {
            collection.addNotEqualsFilter("id", (Object)this.getID());
        }
        return new ItemCollection(collection);
    }

    public String getVersion() {
        return (String)this.get(VERSION);
    }

    protected void setVersion(String version) {
        this.set(VERSION, version);
        this.m_reporter.mutated(VERSION);
    }

    public boolean isDraftVersion() {
        return DRAFT.equals(this.getVersion());
    }

    public ContentItem getDraftVersion() {
        DataObject draft;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting the draft version of " + this));
        }
        if ((draft = (DataObject)this.get(DRAFT_VERSION)) == null) {
            return this;
        }
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)draft);
    }

    public ContentItem getWorkingVersion() {
        return this.getDraftVersion();
    }

    public boolean isPendingVersion() {
        return PENDING.equals(this.getVersion());
    }

    ContentItem getPendingVersion() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getPendingVersion: " + this.getOID()));
        }
        if (this.m_pending.isCached()) {
            return this.m_pending.get();
        }
        return this.m_pending.set(this.getUncachedPendingVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentItem getUncachedPendingVersion() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getUncachedPendingVersion: " + this.getOID()));
        }
        ItemCollection versions = this.getPendingVersions();
        try {
            if (versions.next()) {
                ContentItem contentItem = versions.getContentItem();
                return contentItem;
            }
            ContentItem contentItem = null;
            return contentItem;
        }
        finally {
            versions.close();
        }
    }

    public ItemCollection getPendingVersions() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getPendingVersions: " + this.getOID()));
        }
        DataQuery versions = this.getSession().retrieveQuery(QUERY_PENDING_ITEMS);
        versions.setParameter("itemID", (Object)this.getDraftVersion().getID());
        return new ItemCollection((DataCollection)new DataQueryDataCollectionAdapter(versions, "item"));
    }

    protected void addPendingVersion(ContentItem version) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Adding pending version " + version));
        }
        if (Assert.isEnabled()) {
            Assert.exists((Object)version, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$cms$ContentItem));
            this.assertDraft();
            version.assertPending();
        }
        this.add(VERSIONS, (DomainObject)version);
        this.m_pending.clear();
    }

    public void removePendingVersion(ContentItem version) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing pending version " + version));
        }
        if (Assert.isEnabled()) {
            Assert.exists((Object)version, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$cms$ContentItem));
            this.assertDraft();
            version.assertPending();
        }
        this.remove(VERSIONS, (DomainObject)version);
        this.m_pending.clear();
        version.delete();
    }

    public boolean isLiveVersion() {
        return LIVE.equals(this.getVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentItem getLiveVersion() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Getting the live version of " + this));
        }
        if (LIVE.equals(this.getVersion())) {
            return this;
        }
        if (this.m_live.isCached()) {
            return this.m_live.get();
        }
        s_log.debug((Object)"m_live miss");
        DataAssociationCursor versions = ((DataAssociation)this.get(VERSIONS)).cursor();
        versions.addEqualsFilter(VERSION, (Object)LIVE);
        try {
            if (versions.next()) {
                ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)versions.getDataObject());
                ContentItem contentItem = this.m_live.set(item);
                return contentItem;
            }
            ContentItem contentItem = this.m_live.set(null);
            return contentItem;
        }
        finally {
            versions.close();
        }
    }

    protected void setLiveVersion(ContentItem version) {
        ContentItem live;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting live version to " + version));
        }
        if (Assert.isEnabled()) {
            this.assertDraft();
        }
        if ((live = this.getLiveVersion()) != null) {
            this.remove(VERSIONS, (DomainObject)live);
        }
        if (version == null) {
            this.m_live.set(null);
        } else {
            this.add(VERSIONS, (DomainObject)version);
            this.m_live.set(version);
        }
    }

    public ContentItem getPublicVersion() {
        ContentItem live;
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getPublicVersion: " + this.getOID()));
        }
        if ((live = this.getLiveVersion()) == null) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("getPublicVersion: no live version " + this.getOID()));
            }
            return this.getPendingVersion();
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getPublicVersion: returning live version " + this.getOID()));
        }
        return live;
    }

    protected boolean canPublishToFS() {
        return true;
    }

    protected void publishToFS() {
        if (!this.canPublishToFS()) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Publishing item " + this + " to the file system"));
        }
        this.assertLive();
        QueueManager.queuePublish(this);
    }

    protected void unpublishFromFS() {
        if (!this.canPublishToFS()) {
            return;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Unpublishing item " + this + " to the file system"));
        }
        this.assertLive();
        QueueManager.queueUnpublish(this);
    }

    public boolean isLive() {
        return this.getLiveVersion() != null;
    }

    public void setLive(ContentItem version) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting item " + this + " live with version " + version));
        }
        if (Assert.isEnabled()) {
            Assert.truth((version == null || LIVE.equals(version.getVersion()) ? 1 : 0) != 0, (String)("Item version " + version + " must be null or " + "the live version"));
        }
        if (this.isLive()) {
            s_log.debug((Object)"The item is already live; getting the current live version");
            ContentItem oldVersion = this.getLiveVersion();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("The current live version is " + oldVersion));
            }
            ACSObject parent = null;
            if (version == null) {
                DataQuery items = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getLiveItemsWithSameParent");
                items.addNotEqualsFilter("id", (Object)oldVersion.getID());
                items.setParameter("itemId", (Object)oldVersion.getID());
                if (!items.next()) {
                    parent = this.getParent();
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)(oldVersion + " is the last child of " + parent));
                    }
                }
                items.close();
            }
            if (oldVersion.canPublishToFS()) {
                oldVersion.unpublishFromFS();
            }
            if (version == null || !version.equals(oldVersion)) {
                s_log.debug((Object)"Deleting old live version");
                oldVersion.delete();
                PublishedLink.refreshOnUnpublish(this);
            }
            if (parent instanceof ContentBundle || parent instanceof Folder) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Parent of " + oldVersion + " is " + parent + "; unpublishing the parent"));
                }
                ((ContentItem)parent).unpublish();
            }
            s_log.debug((Object)"Setting the live version association to null and saving");
            this.setLiveVersion(null);
            this.save();
        }
        if (version != null) {
            s_log.debug((Object)"The new version is not null; setting the live version association");
            this.setLiveVersion(version);
            this.save();
            PublishedLink.updateLiveLinks(version);
            this.save();
            if (version.canPublishToFS()) {
                version.publishToFS();
            }
        }
    }

    public ContentItem publish(LifecycleDefinition cycleDef, Date startDate) {
        this.applyTag("Published");
        Versions.suspendVersioning();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Publishing item " + this + " with lifecycle " + "definition " + (Object)((Object)cycleDef) + " and start date " + startDate));
        }
        Lifecycle cycle = cycleDef.createFullLifecycle(startDate, PUBLISH_LISTENER_CLASS);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Instantiated lifecycle " + (Object)((Object)cycle)));
        }
        ContentItem pending = this.createPendingVersion(cycle);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Created pending content item " + pending));
        }
        if (Assert.isEnabled()) {
            Assert.exists((Object)pending, (Class)(class$com$arsdigita$cms$ContentItem == null ? (class$com$arsdigita$cms$ContentItem = ContentItem.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$cms$ContentItem));
            Assert.truth((PENDING.equals(pending.getVersion()) || LIVE.equals(pending.getVersion()) ? 1 : 0) != 0, (String)("The new pending item must be pending or live; instead it is " + pending.getVersion()));
        }
        return pending;
    }

    public void unpublish() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Unpublishing item " + this));
        }
        Versions.suspendVersioning();
        if (this.isLive()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("The item is currently live; removing the lifecycle of the public version, " + this.getPublicVersion()));
            }
            this.removeLifecycle(this.getPublicVersion());
            this.setLive(null);
        } else {
            s_log.debug((Object)"The item is not live; removing its lifecycle");
            this.removeLifecycle(this);
        }
        s_log.debug((Object)"Removing all pending versions");
        ItemCollection pending = this.getPendingVersions();
        while (pending.next()) {
            ContentItem item = pending.getContentItem();
            this.removePendingVersion(item);
        }
        this.save();
    }

    public Lifecycle getLifecycle() {
        s_log.debug((Object)"Resolving the item's lifecycle");
        Lifecycle lifecycle = LifecycleService.getLifecycle((ACSObject)this);
        if (lifecycle == null) {
            s_log.debug((Object)"The item has no lifecycle; checking if the public version has a lifecycle");
            ContentItem pub = this.getPublicVersion();
            if (pub == null) {
                s_log.debug((Object)"There is no public version; returning null");
                return null;
            }
            Lifecycle cyclelife = LifecycleService.getLifecycle((ACSObject)pub);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("The public version has a lifecycle; returning " + (Object)((Object)cyclelife)));
            }
            return cyclelife;
        }
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Found " + (Object)((Object)lifecycle)));
        }
        return lifecycle;
    }

    public boolean isPublished() {
        return this.getLifecycle() != null;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting lifecycle to " + (Object)((Object)lifecycle) + " on " + this));
        }
        Assert.exists((Object)((Object)lifecycle), (Class)(class$com$arsdigita$cms$lifecycle$Lifecycle == null ? (class$com$arsdigita$cms$lifecycle$Lifecycle = ContentItem.class$("com.arsdigita.cms.lifecycle.Lifecycle")) : class$com$arsdigita$cms$lifecycle$Lifecycle));
        LifecycleService.setLifecycle((ACSObject)this, lifecycle);
    }

    public void removeLifecycle(ContentItem itemToRemove) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Removing lifecycle instance from item " + itemToRemove));
        }
        LifecycleService.removeLifecycle((ACSObject)itemToRemove);
    }

    private ContentBundle getBundle() {
        ACSObject parent = this.getParent();
        if (parent instanceof ContentBundle) {
            return (ContentBundle)parent;
        }
        return null;
    }

    private void setBundle(ContentBundle bundle) {
        this.setParent((ACSObject)bundle);
    }

    public CategoryCollection getCategoryCollection() {
        ContentBundle bundle = this.getBundle();
        if (bundle != null) {
            return bundle.getCategoryCollection();
        }
        return new CategorizedObject((ACSObject)this).getParents();
    }

    public Iterator getCategories(String useContext) {
        ContentBundle bundle = this.getBundle();
        if (bundle != null) {
            return bundle.getCategories(useContext);
        }
        Category root = Category.getRootForObject((ACSObject)this.getContentSection(), (String)useContext);
        CategoryCollection cats = root.getDescendants();
        cats.addEqualsFilter("childObjects.id", (Object)this.getID());
        LinkedList<Category> categories = new LinkedList<Category>();
        while (cats.next()) {
            categories.add(cats.getCategory());
        }
        return categories.iterator();
    }

    public void setDefaultCategory(Category category) {
        ContentBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.setDefaultCategory(category);
            return;
        }
        CategorizedObject cObj = new CategorizedObject((ACSObject)this);
        cObj.setDefaultParentCategory(category);
        category.save();
    }

    public void addCategory(Category category) {
        ContentBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.addCategory(category);
            return;
        }
        category.addChild((ACSObject)this);
        category.save();
    }

    public void removeCategory(Category category) {
        ContentBundle bundle = this.getBundle();
        if (bundle != null) {
            bundle.removeCategory(category);
            return;
        }
        category.removeChild((ACSObject)this);
        category.save();
    }

    public ContentItem copy() {
        return this.copy(null, false);
    }

    public final ContentItem copy(ContentItem newParent, boolean copyServices) {
        ContentItem newItem = this.makeCopy();
        if (newParent != null) {
            newItem.setParent((ACSObject)newParent);
        }
        if (copyServices) {
            newItem.copyServicesFrom(this);
        }
        return newItem;
    }

    protected ContentItem makeCopy() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Copy taking place", new Throwable("trace"));
        }
        ContentItem newItem = new ObjectCopier().copyItem(this);
        newItem.setContentSection(this.getContentSection());
        newItem.save();
        return newItem;
    }

    public void copyServicesFrom(ContentItem source) {
        ObjectCopier.copyServices(this, source);
    }

    protected ContentItem createPendingVersion(Lifecycle cycle) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Creating a pending version with lifecycle " + (Object)((Object)cycle)));
        }
        return new VersionCopier(cycle).copyItem(this);
    }

    public void promotePendingVersion(ContentItem pending) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Promoting pending version " + pending + " to live"));
        }
        this.assertDraft();
        boolean isNewVersionLive = pending.isLiveVersion();
        ContentItem live = this.getLiveVersion();
        if (live != null) {
            if (live.equals(pending) && isNewVersionLive) {
                return;
            }
            this.setLive(null);
        }
        if (!isNewVersionLive) {
            pending.setVersionRecursively(LIVE);
        }
        this.setLive(pending);
        ContentBundle draftBundle = this.getBundle();
        ContentBundle liveBundle = pending.getBundle();
        if (draftBundle != null && liveBundle != null && !liveBundle.isLiveVersion()) {
            draftBundle.promotePendingVersion(liveBundle);
        }
        this.save();
    }

    protected void setVersionRecursively(String version) {
        s_log.debug((Object)"Recursively updating the version attribute of the item");
        new VersionUpdater(version).updateItemVersion(this);
    }

    public ContentItem createLiveVersion() {
        s_log.debug((Object)"Creating live version");
        ContentItem pending = this.createPendingVersion(null);
        this.promotePendingVersion(pending);
        return pending;
    }

    protected final boolean copyProperty(ContentItem source, String attribute, ItemCopier copier) {
        throw new UnsupportedOperationException("use copyProperty(CustomCopy, Property, ItemCopier) for copying");
    }

    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        ACSObject parent;
        String attribute = property.getName();
        if (CHILDREN.equals(attribute)) {
            return true;
        }
        if (VERSIONS.equals(attribute)) {
            return true;
        }
        if (ANCESTORS.equals(attribute)) {
            return true;
        }
        if (AUDITING.equals(attribute)) {
            return true;
        }
        if ("categories".equals(attribute)) {
            return true;
        }
        if (PARENT.equals(attribute) && (parent = ((ContentItem)source).getParent()) != null && copier.getCopyType() == 1) {
            if (parent instanceof ContentBundle) {
                ContentBundle bundle = (ContentBundle)parent;
                ContentBundle liveBundle = (ContentBundle)bundle.getPublicVersion();
                if (liveBundle == null) {
                    liveBundle = (ContentBundle)bundle.createPendingVersion(null);
                } else {
                    HashSet<Category> liveCatSet = new HashSet<Category>();
                    HashSet<Category> draftCatSet = new HashSet<Category>();
                    CategoryCollection liveCategories = liveBundle.getCategoryCollection();
                    while (liveCategories.next()) {
                        liveCatSet.add(liveCategories.getCategory());
                    }
                    liveCategories.close();
                    CategoryCollection draftCategories = bundle.getCategoryCollection();
                    while (draftCategories.next()) {
                        draftCatSet.add(draftCategories.getCategory());
                    }
                    draftCategories.close();
                    HashSet catsToRemove = new HashSet(liveCatSet);
                    catsToRemove.removeAll(draftCatSet);
                    HashSet catsToAdd = new HashSet(draftCatSet);
                    catsToAdd.removeAll(liveCatSet);
                    Iterator removeIter = catsToRemove.iterator();
                    while (removeIter.hasNext()) {
                        liveBundle.removeCategory((Category)removeIter.next());
                    }
                    Iterator addIter = catsToAdd.iterator();
                    while (addIter.hasNext()) {
                        liveBundle.addCategory((Category)addIter.next());
                    }
                }
                this.setBundle(liveBundle);
                return true;
            }
            if (parent instanceof Folder) {
                Folder folder = (Folder)parent;
                Folder liveFolder = (Folder)folder.getLiveVersion();
                if (liveFolder == null) {
                    liveFolder = (Folder)folder.createLiveVersion();
                }
                this.setParent((ACSObject)liveFolder);
                return true;
            }
        }
        return false;
    }

    public boolean copyServices(ContentItem srcItem) {
        return false;
    }

    public String getLanguage() {
        return (String)this.get(LANGUAGE);
    }

    public void setLanguage(String language) {
        this.set(LANGUAGE, language);
        this.m_reporter.mutated(LANGUAGE);
    }

    public com.arsdigita.globalization.Locale getLocale() {
        com.arsdigita.globalization.Locale locale = null;
        try {
            locale = com.arsdigita.globalization.Locale.fromJavaLocale((Locale)new Locale(this.getLanguage(), ""));
        }
        catch (GlobalizationException e) {
            s_log.warn((Object)"GlobalizationException thrown in getLocale()", (Throwable)e);
            throw new UncheckedWrapperException(e.getMessage());
        }
        Assert.exists((Object)locale, (Class)(class$com$arsdigita$globalization$Locale == null ? (class$com$arsdigita$globalization$Locale = ContentItem.class$("com.arsdigita.globalization.Locale")) : class$com$arsdigita$globalization$Locale));
        return locale;
    }

    public final void assertDraft() {
        Assert.equal((Object)DRAFT, (Object)this.getVersion());
    }

    public final void assertPending() {
        Assert.equal((Object)PENDING, (Object)this.getVersion());
    }

    public final void assertLive() {
        Assert.equal((Object)LIVE, (Object)this.getVersion());
    }

    public final void assertMaster() {
        Assert.truth((boolean)this.isMaster(), (String)("Item " + this.getOID() + " is a top-level item"));
    }

    protected void beforeDelete() {
        super.beforeDelete();
        DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.Link");
        dc.addEqualsFilter("targetItem.id", (Object)this.getID());
        while (dc.next()) {
            Link link = (Link)DomainObjectFactory.newInstance((DataObject)dc.getDataObject());
            link.setTargetItem(null);
        }
        dc = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.ContentGroupAssociation");
        dc.addEqualsFilter("contentItem.id", (Object)this.getID());
        while (dc.next()) {
            ContentGroupAssociation groupAssoc = (ContentGroupAssociation)DomainObjectFactory.newInstance((DataObject)dc.getDataObject());
            groupAssoc.setContentItem(null);
        }
    }

    public User getCreationUser() {
        return this.m_audit_trail.getCreationUser();
    }

    public Date getCreationDate() {
        return this.m_audit_trail.getCreationDate();
    }

    public String getCreationIP() {
        return this.m_audit_trail.getCreationIP();
    }

    public User getLastModifiedUser() {
        return this.m_audit_trail.getLastModifiedUser();
    }

    public Date getLastModifiedDate() {
        return this.m_audit_trail.getLastModifiedDate();
    }

    public String getLastModifiedIP() {
        return this.m_audit_trail.getLastModifiedIP();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VersionCache {
        private ContentItem m_version = null;
        private boolean m_cached = false;

        VersionCache() {
        }

        boolean isCached() {
            return this.m_cached;
        }

        ContentItem get() {
            Assert.truth((boolean)this.m_cached);
            return this.m_version;
        }

        ContentItem set(ContentItem version) {
            this.m_version = version;
            this.m_cached = true;
            return this.m_version;
        }

        void clear() {
            this.m_version = null;
            this.m_cached = false;
        }
    }
}

