/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.Asset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BinaryAsset
extends Asset {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/BinaryAsset.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected BinaryAsset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    protected BinaryAsset(String type) {
        super(type);
    }

    public BinaryAsset(DataObject obj) {
        super(obj);
    }

    public abstract String getBaseDataObjectType();

    public long readBytes(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8];
        int length = -1;
        while ((length = is.read(buffer)) != -1) {
            os.write(buffer, 0, length);
        }
        byte[] content = os.toByteArray();
        this.setContent(content);
        return content.length;
    }

    public long writeBytes(OutputStream os) throws IOException {
        byte[] bytes = this.getContent();
        os.write(bytes);
        return bytes.length;
    }

    protected abstract byte[] getContent();

    protected abstract void setContent(byte[] var1);

    public long getSize() {
        long size = 0L;
        byte[] content = this.getContent();
        if (content != null) {
            size = content.length;
        }
        return size;
    }
}

