/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.Article;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.CustomCopy;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemCollection;
import com.arsdigita.cms.ItemCopier;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class ArticleImageAssociation
extends ContentItem {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ArticleImageAssociation.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ArticleImageAssociation";
    protected static final String ARTICLE = "captionArticle";
    protected static final String IMAGE = "imageAsset";
    protected static final String CAPTION = "caption";
    protected static final String ARTICLE_ID = "articleId";
    protected static final String IMAGE_ID = "imageId";

    public ArticleImageAssociation() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ArticleImageAssociation(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ArticleImageAssociation(DataObject obj) {
        super(obj);
    }

    public ArticleImageAssociation(String type) {
        super(type);
    }

    public static ArticleImageAssociation retrieveAssociation(BigDecimal articleID, BigDecimal imageID) {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter(ARTICLE_ID, (Object)articleID);
        collection.addEqualsFilter(IMAGE_ID, (Object)imageID);
        collection.addEqualsFilter("isDeleted", (Object)new BigDecimal(0.0));
        if (collection.next()) {
            ArticleImageAssociation association = new ArticleImageAssociation(collection.getDataObject());
            collection.close();
            return association;
        }
        return null;
    }

    public static boolean imageHasDirectAssociation(BigDecimal imageID) {
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter(IMAGE_ID, (Object)imageID);
        collection.addEqualsFilter("isDeleted", (Object)new BigDecimal(0.0));
        if (collection.next()) {
            collection.close();
            return true;
        }
        return false;
    }

    public static boolean imageHasAssociation(BigDecimal imageID) {
        try {
            ImageAsset asset = (ImageAsset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ImageAsset", (Object)imageID));
            return asset == null ? false : ArticleImageAssociation.imageHasAssociation(asset);
        }
        catch (DataObjectNotFoundException e) {
            return false;
        }
    }

    public static boolean imageHasAssociation(ImageAsset image) {
        ContentItem item;
        Assert.assertNotNull((Object)image);
        boolean returnValue = ArticleImageAssociation.imageHasDirectAssociation(image.getID());
        if (!returnValue && !image.getVersion().equals("draft") && (item = image.getWorkingVersion()) != null) {
            returnValue = ArticleImageAssociation.imageHasDirectAssociation(item.getID());
        }
        if (!returnValue && !image.getVersion().equals("pending")) {
            ItemCollection pendingVersions = image.getPendingVersions();
            while (pendingVersions.next()) {
                ContentItem item2 = pendingVersions.getContentItem();
                returnValue = returnValue || ArticleImageAssociation.imageHasDirectAssociation(item2.getID());
            }
        }
        if (!returnValue && !image.getVersion().equals("live") && (item = image.getLiveVersion()) != null) {
            returnValue = ArticleImageAssociation.imageHasDirectAssociation(item.getID());
        }
        DataCollection collection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        collection.addEqualsFilter(IMAGE_ID, (Object)image.getID());
        collection.addEqualsFilter("isDeleted", (Object)new BigDecimal(0.0));
        if (collection.next()) {
            collection.close();
            return true;
        }
        return false;
    }

    public BigDecimal getArticleID() {
        return (BigDecimal)this.get(ARTICLE_ID);
    }

    public Article getArticle() {
        DataCollection col = SessionManager.getSession().retrieve(ARTICLE);
        if (col.next()) {
            Article art = new Article(col.getDataObject());
            col.close();
            return art;
        }
        return null;
    }

    public void setArticle(Article article) {
        this.setAssociation(ARTICLE, (DomainObject)article);
    }

    public BigDecimal getImageID() {
        return (BigDecimal)this.get(IMAGE_ID);
    }

    public ImageAsset getImage() {
        return (ImageAsset)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get(IMAGE)));
    }

    public void setImage(ImageAsset image) {
        this.setAssociation(IMAGE, (DomainObject)image);
    }

    public String getCaption() {
        return (String)this.get(CAPTION);
    }

    public void setCaption(String caption) {
        this.set(CAPTION, caption);
    }

    public boolean copyProperty(CustomCopy source, Property property, ItemCopier copier) {
        String attribute = property.getName();
        if (IMAGE_ID.equals(attribute) || ARTICLE_ID.equals(attribute)) {
            return true;
        }
        if (copier.getCopyType() == 1 && IMAGE.equals(attribute)) {
            ImageAsset liveImage;
            ImageAsset image = ((ArticleImageAssociation)source).getImage();
            if (image != null && (liveImage = (ImageAsset)image.getLiveVersion()) == null) {
                liveImage = (ImageAsset)image.createLiveVersion();
            }
            return false;
        }
        return super.copyProperty(source, property, copier);
    }
}

