/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.DomainObjectSelectionModel;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class ACSObjectSelectionModel
implements DomainObjectSelectionModel {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ACSObjectSelectionModel == null ? (class$com$arsdigita$cms$ACSObjectSelectionModel = ACSObjectSelectionModel.class$("com.arsdigita.cms.ACSObjectSelectionModel")) : class$com$arsdigita$cms$ACSObjectSelectionModel));
    private RequestLocal m_object = new RequestLocal();
    private RequestLocal m_loaded = new RequestLocal(){

        protected Object initialValue(PageState state) {
            return Boolean.FALSE;
        }
    };
    private Class m_javaClass;
    private Constructor m_constructor;
    private String m_objectType;
    private SingleSelectionModel m_model;
    static /* synthetic */ Class class$com$arsdigita$cms$ACSObjectSelectionModel;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;

    public ACSObjectSelectionModel(String javaClass, String objectType, String parameterName) {
        this(javaClass, objectType, new BigDecimalParameter(parameterName));
    }

    public ACSObjectSelectionModel(String javaClass, String objectType, BigDecimalParameter parameter) {
        this(javaClass, objectType, (SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)parameter));
    }

    public ACSObjectSelectionModel(String javaClass, String objectType, SingleSelectionModel model) {
        try {
            this.m_javaClass = Class.forName(javaClass);
            this.m_constructor = this.m_javaClass.getConstructor(class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = ACSObjectSelectionModel.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        }
        catch (Exception e) {
            s_log.error((Object)("Problem loading class " + javaClass), (Throwable)e);
            throw new UncheckedWrapperException("Problem loading class " + javaClass);
        }
        this.m_objectType = objectType;
        this.m_model = model;
    }

    public void setSelectedKey(PageState state, Object key) {
        BigDecimal id = null;
        if (key != null) {
            id = new BigDecimal(key.toString());
        }
        this.m_object.set(state, null);
        this.m_loaded.set(state, (Object)Boolean.FALSE);
        this.m_model.setSelectedKey(state, (Object)id);
    }

    public DomainObject getSelectedObject(PageState state) {
        if (!this.isInitialized(state)) {
            this.m_loaded.set(state, (Object)Boolean.TRUE);
            BigDecimal id = (BigDecimal)this.getSelectedKey(state);
            if (id == null) {
                return null;
            }
            try {
                OID oid = new OID(this.m_objectType, (Object)id);
                ACSObject item = (ACSObject)this.m_constructor.newInstance(oid);
                this.m_object.set(state, (Object)item);
                return item;
            }
            catch (Exception ex) {
                s_log.warn((Object)("ACSObject " + id + " not found."), (Throwable)ex);
                return null;
            }
        }
        return (ACSObject)this.m_object.get(state);
    }

    public void setSelectedObject(PageState state, DomainObject object) {
        ACSObject item = (ACSObject)object;
        this.m_object.set(state, (Object)item);
        if (item == null) {
            this.m_loaded.set(state, (Object)Boolean.FALSE);
            this.m_model.setSelectedKey(state, null);
        } else {
            this.m_loaded.set(state, (Object)Boolean.TRUE);
            this.m_model.setSelectedKey(state, (Object)item.getID());
        }
    }

    public boolean isInitialized(PageState state) {
        return (Boolean)this.m_loaded.get(state);
    }

    public ACSObject createACSObject(BigDecimal id) throws ServletException {
        s_log.debug((Object)("Creating a new object: " + id));
        try {
            ACSObject item = (ACSObject)this.m_javaClass.newInstance();
            s_log.info((Object)("XXXXXXXX creating new object with id " + item.getID() + ";;; id should be " + id));
            return item;
        }
        catch (Exception e) {
            s_log.error((Object)("Error creating ACSObject with id = " + id), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public Class getJavaClass() {
        return this.m_javaClass;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public SingleSelectionModel getSingleSelectionModel() {
        return this.m_model;
    }

    public boolean isSelected(PageState state) {
        return this.m_model.isSelected(state);
    }

    public Object getSelectedKey(PageState state) {
        return this.m_model.getSelectedKey(state);
    }

    public void clearSelection(PageState state) {
        this.m_model.clearSelection(state);
        this.m_object.set(state, null);
        this.m_loaded.set(state, (Object)Boolean.FALSE);
    }

    public void addChangeListener(ChangeListener l) {
        this.m_model.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_model.removeChangeListener(l);
    }

    public ParameterModel getStateParameter() {
        return this.m_model.getStateParameter();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

