/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.OID;
import java.util.Date;

class UnfinishedNotification
extends DomainObject {
    static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.workflow.UnfinishedNotification";
    private static final String ID = "id";
    private static final String LAST_SENT_DATE = "lastSentDate";
    private static final String NUM_SENT = "numSent";

    private UnfinishedNotification(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    private UnfinishedNotification(CMSTask task) {
        super(BASE_DATA_OBJECT_TYPE);
        this.set(ID, task.getID());
    }

    public static UnfinishedNotification retrieveForTask(CMSTask task) {
        try {
            return new UnfinishedNotification(new OID(BASE_DATA_OBJECT_TYPE, (Object)task.getID()));
        }
        catch (DataObjectNotFoundException de) {
            return new UnfinishedNotification(task);
        }
    }

    public Date getLastNotificationDate() {
        return (Date)this.get(LAST_SENT_DATE);
    }

    public int getNumNotifications() {
        Integer num = (Integer)this.get(NUM_SENT);
        if (num != null) {
            return num;
        }
        return 0;
    }

    public void incrNumNotifications() {
        int num = this.getNumNotifications();
        this.set(NUM_SENT, new Integer(++num));
        this.set(LAST_SENT_DATE, new Date());
    }
}

